/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.communications.command.server;

import java.io.Serializable;
import javax.management.ObjectName;
import org.rhq.enterprise.communications.command.CommandType;

public class CommandServiceDirectoryEntry
implements Serializable {
    private final String m_subsystem;
    private final CommandType m_commandType;
    private final ObjectName m_commandServiceName;
    private static final long serialVersionUID = 1L;

    public CommandServiceDirectoryEntry(String subsystem, CommandType commandType, ObjectName commandServiceName) throws IllegalArgumentException {
        if (commandType == null) {
            throw new IllegalArgumentException("commandType=null");
        }
        if (commandServiceName == null) {
            throw new IllegalArgumentException("commandServiceName=null");
        }
        this.m_subsystem = subsystem == null || subsystem.equals(",null,") ? null : subsystem;
        this.m_commandType = commandType;
        this.m_commandServiceName = commandServiceName;
    }

    public String getSubsystem() {
        return this.m_subsystem;
    }

    public CommandType getCommandType() {
        return this.m_commandType;
    }

    public ObjectName getCommandServiceName() {
        return this.m_commandServiceName;
    }

    public String toString() {
        StringBuffer strBuf = new StringBuffer("CommandServiceDirectoryEntry: ");
        strBuf.append("subsystem=[");
        strBuf.append(this.m_subsystem);
        strBuf.append("]; command-type=[");
        strBuf.append(this.m_commandType);
        strBuf.append("]; command-service-name=[");
        strBuf.append(this.m_commandServiceName);
        strBuf.append("]");
        return strBuf.toString();
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof CommandServiceDirectoryEntry)) {
            return false;
        }
        CommandServiceDirectoryEntry compareThis = (CommandServiceDirectoryEntry)obj;
        boolean retVal = false;
        if (this.m_commandType.equals(compareThis.m_commandType) && this.m_commandServiceName.equals(compareThis.m_commandServiceName)) {
            String compareThisSubsystem;
            String thisSubsystem = this.m_subsystem == null ? ",null," : this.m_subsystem;
            String string = compareThisSubsystem = compareThis.m_subsystem == null ? ",null," : compareThis.m_subsystem;
            if (thisSubsystem.equals(compareThisSubsystem)) {
                retVal = true;
            }
        }
        return retVal;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }
}

