/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.util.file;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.rhq.core.util.collection.IntHashMap;
import org.rhq.core.util.file.FileVisitor;
import org.rhq.core.util.file.PathFilter;
import org.rhq.core.util.stream.StreamUtil;

public class FileUtil {
    private static IntHashMap invalidChars = null;

    public static File createTempDirectory(String prefix, String suffix, File parentDirectory) throws IOException {
        File tmpDir = File.createTempFile(prefix, suffix, parentDirectory);
        boolean deleteOk = tmpDir.delete();
        boolean mkdirsOk = tmpDir.mkdirs();
        if (!deleteOk || !mkdirsOk) {
            throw new IOException("Failed to create temp directory named [" + tmpDir + "]");
        }
        return tmpDir;
    }

    public static void purge(File dir, boolean deleteIt) {
        if (dir != null) {
            File[] doomedFiles;
            if (dir.isDirectory() && (doomedFiles = dir.listFiles()) != null) {
                for (File doomedFile : doomedFiles) {
                    FileUtil.purge(doomedFile, true);
                }
            }
            if (deleteIt) {
                dir.delete();
            }
        }
    }

    public static void copyFile(File inFile, File outFile) throws FileNotFoundException, IOException {
        BufferedInputStream is = new BufferedInputStream(new FileInputStream(inFile));
        BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(outFile));
        StreamUtil.copy(is, os);
    }

    public static void copyStream(InputStream is, OutputStream os) throws IOException {
        StreamUtil.copy(is, os, false);
    }

    public static void copyStream(InputStream is, OutputStream os, byte[] buf) throws IOException {
        int bytesRead = 0;
        while ((bytesRead = is.read(buf)) != -1) {
            os.write(buf, 0, bytesRead);
        }
    }

    public static void writeFile(InputStream inputStream, File outputFile) throws IOException {
        FileOutputStream fos = new FileOutputStream(outputFile);
        FileUtil.copyStream(inputStream, fos);
        inputStream.close();
        fos.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String findString(String fname, String toFind) throws IOException {
        StringBuffer result = null;
        BufferedReader in = new BufferedReader(new FileReader(fname));
        try {
            int numread;
            char[] data = new char[8096];
            int toFindIndex = 0;
            char lastchar = 'a';
            while ((numread = in.read(data, 0, 8096)) != -1) {
                for (int i = 0; i < numread; ++i) {
                    if (toFindIndex >= toFind.length() || data[i] == toFind.charAt(toFindIndex)) {
                        if (result == null) {
                            result = new StringBuffer();
                        }
                        if (Character.isISOControl(data[i])) {
                            String string = result.toString();
                            return string;
                        }
                        result.append(data[i]);
                        ++toFindIndex;
                    } else if (toFindIndex > 0) {
                        if (data[i] != lastchar) {
                            result = null;
                            toFindIndex = 0;
                            continue;
                        }
                        --toFindIndex;
                        --i;
                        result.deleteCharAt(result.length() - 1);
                        continue;
                    }
                    lastchar = data[i];
                }
            }
        }
        catch (IOException e) {
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
        }
        if (result != null) {
            return result.toString();
        }
        return null;
    }

    public static String getRelativePath(File path, File base) {
        String base_abs;
        String path_abs = path.getAbsolutePath();
        int idx = path_abs.indexOf(base_abs = base.getAbsolutePath());
        if (idx == -1) {
            throw new IllegalArgumentException("Path (" + path_abs + ") " + "does not contain " + "base (" + base_abs + ")");
        }
        String relativePath = "." + path_abs.substring(idx + base_abs.length());
        return relativePath;
    }

    private static void initInvalidChars() {
        if (invalidChars != null) {
            return;
        }
        invalidChars = new IntHashMap();
        char[] invalid = new char[]{'\\', '/', ':', '*', '?', '\'', '\"', '~', '<', '>', '|', '#', '{', '}', '%', '&', ' '};
        for (int i = 0; i < invalid.length; ++i) {
            invalidChars.put(invalid[i], Boolean.TRUE);
        }
    }

    public static String escape(String name) {
        FileUtil.initInvalidChars();
        int len = name.length();
        StringBuffer buf = new StringBuffer(len);
        char[] chars = name.toCharArray();
        for (int i = 0; i < len; ++i) {
            char c = chars[i];
            if (invalidChars.get(c) == Boolean.TRUE) {
                buf.append("_");
                continue;
            }
            buf.append(c);
        }
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean canWrite(File dir) throws IOException {
        if (!dir.isDirectory()) {
            throw new IOException(dir.getPath() + " is not a directory");
        }
        File tmp = null;
        try {
            tmp = File.createTempFile("rhq", null, dir);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (tmp != null) {
                tmp.delete();
            }
        }
    }

    public static String stripDriveLetter(StringBuilder path) {
        String driveLetter = null;
        Pattern regex = Pattern.compile("^([a-zA-Z]):.*");
        Matcher matcher = regex.matcher(path);
        if (matcher.matches()) {
            driveLetter = matcher.group(1);
            path.replace(0, 2, "");
        }
        return driveLetter;
    }

    public static String useForwardSlash(String path) {
        return null != path ? path.replace('\\', '/') : null;
    }

    public static String getFileName(String path, String separator) {
        if (null == path) {
            return null;
        }
        int i = path.lastIndexOf(separator);
        return i < 0 ? path.trim() : path.substring(++i).trim();
    }

    public static void forEachFile(File directory, FileVisitor visitor) {
        LinkedList<File> directories = new LinkedList<File>();
        directories.push(directory);
        while (!directories.isEmpty()) {
            File dir = (File)directories.pop();
            for (File file : dir.listFiles()) {
                if (file.isDirectory()) {
                    directories.push(file);
                    continue;
                }
                visitor.visit(file);
            }
        }
    }

    public static Pattern generateRegex(List<PathFilter> filters) {
        boolean first = true;
        StringBuilder regex = new StringBuilder();
        for (PathFilter filter : filters) {
            if (!first) {
                regex.append("|");
            } else {
                first = false;
            }
            regex.append("(");
            File path = new File(filter.getPath());
            if (FileUtil.isEmpty(filter.getPattern()) && path.isDirectory()) {
                regex.append(".*");
            } else if (FileUtil.isEmpty(filter.getPattern()) && !path.isDirectory()) {
                FileUtil.buildPatternRegex(path.getAbsolutePath(), regex);
            } else if (!FileUtil.isEmpty(filter.getPattern())) {
                regex.append(path).append("/").append("(");
                FileUtil.buildPatternRegex(filter.getPattern(), regex);
                regex.append(")");
            }
            regex.append(")");
        }
        return Pattern.compile(regex.toString());
    }

    private static void buildPatternRegex(String pattern, StringBuilder regex) {
        for (int i = 0; i < pattern.length(); ++i) {
            char c = pattern.charAt(i);
            if (c == '?') {
                regex.append('.');
                continue;
            }
            if (c == '*') {
                char c2;
                if (i + 1 < pattern.length() && (c2 = pattern.charAt(i + 1)) == '*') {
                    regex.append(".*");
                    i += 2;
                    continue;
                }
                regex.append("[^/]*");
                continue;
            }
            if (c == '.') {
                regex.append("\\.");
                continue;
            }
            regex.append(c);
        }
    }

    private static boolean isEmpty(String s) {
        return s == null || s.length() == 0;
    }
}

