/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.configuration.job;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.resource.group.ResourceGroup;
import org.rhq.core.domain.util.PageControl;
import org.rhq.core.domain.util.PageList;
import org.rhq.enterprise.server.configuration.ConfigurationManagerLocal;
import org.rhq.enterprise.server.configuration.job.AbstractGroupConfigurationUpdateJob;

public class GroupPluginConfigurationUpdateJob
extends AbstractGroupConfigurationUpdateJob {
    private static final String JOB_NAME_PREFIX = "rhq-apcu-";
    private final Log log = LogFactory.getLog(GroupPluginConfigurationUpdateJob.class);

    public static JobDetail getJobDetail(ResourceGroup group, Subject subject, JobDataMap jobDataMap) {
        return AbstractGroupConfigurationUpdateJob.getJobDetail(group, subject, jobDataMap, GroupPluginConfigurationUpdateJob.class, JOB_NAME_PREFIX);
    }

    @Override
    protected List<Integer> getConfigurationUpdateIds(Integer groupPluginConfigurationUpdateId, ConfigurationManagerLocal configurationManager, PageControl pc) {
        PageList<Integer> pagedChildUpdateIds = configurationManager.findPluginConfigurationUpdatesByParentId(groupPluginConfigurationUpdateId, pc);
        return pagedChildUpdateIds;
    }

    @Override
    protected long getConfigurationUpdateCount(Integer groupPluginConfigurationUpdateId, ConfigurationManagerLocal configurationManager) {
        long childPluginConfigurationUpdateCount = configurationManager.getPluginConfigurationUpdateCountByParentId(groupPluginConfigurationUpdateId);
        return childPluginConfigurationUpdateCount;
    }

    @Override
    protected void executeConfigurationUpdate(ConfigurationManagerLocal configurationManager, Integer childUpdateId, Subject subject) {
        configurationManager.completePluginConfigurationUpdate(childUpdateId);
    }

    @Override
    protected void completeGroupConfigurationUpdate(ConfigurationManagerLocal configurationManager, Integer groupConfigurationUpdateId, String errorMessages) {
        if (errorMessages != null) {
            this.log.error((Object)("Failed to execute one or more plugin Configuration updates that were part of a group update - details: " + errorMessages));
        }
        configurationManager.updateGroupPluginConfigurationUpdateStatus(groupConfigurationUpdateId, errorMessages);
    }
}

