/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.drift;

import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.logging.LogFactory;
import org.rhq.enterprise.communications.ServiceContainer;
import org.rhq.enterprise.communications.command.client.ClientCommandSender;
import org.rhq.enterprise.communications.command.client.ClientCommandSenderConfiguration;
import org.rhq.enterprise.communications.command.client.RemoteInputStream;
import org.rhq.enterprise.server.core.comm.ServerCommunicationsServiceUtil;

public class DriftUtil {
    static InputStream remoteStream(InputStream stream) {
        RemoteInputStream remoteStream = (RemoteInputStream)stream;
        ServiceContainer serviceContainer = ServerCommunicationsServiceUtil.getService().getServiceContainer();
        ClientCommandSenderConfiguration config = serviceContainer.getClientConfiguration();
        ClientCommandSender sender = serviceContainer.createClientCommandSender(remoteStream.getServerEndpoint(), config);
        sender.startSending();
        remoteStream.setClientCommandSender(sender);
        return stream;
    }

    static void safeClose(OutputStream os) {
        if (null != os) {
            try {
                os.close();
            }
            catch (Exception e) {
                LogFactory.getLog(DriftUtil.class).warn((Object)"Failed to close OutputStream", (Throwable)e);
            }
        }
    }

    static void safeClose(InputStream is) {
        if (null != is) {
            try {
                is.close();
            }
            catch (Exception e) {
                LogFactory.getLog(DriftUtil.class).warn((Object)"Failed to close InputStream", (Throwable)e);
            }
        }
    }
}

