/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.measurement;

import java.util.Arrays;
import java.util.List;
import org.rhq.core.clientapi.util.StringUtil;
import org.rhq.core.domain.auth.Subject;
import org.rhq.enterprise.server.auth.prefs.SubjectPreferencesBase;
import org.rhq.enterprise.server.measurement.util.MeasurementUtils;

public class MeasurementPreferences
extends SubjectPreferencesBase {
    public static final String PREF_FAV_RESOURCE_METRICS_PREFIX = ".resource.common.monitor.visibility.favoriteMetrics";
    public static final String PREF_METRIC_RANGE = ".resource.common.monitor.visibility.metricRange";
    public static final String PREF_METRIC_RANGE_LASTN = ".resource.common.monitor.visibility.metricRange.lastN";
    public static final String PREF_METRIC_RANGE_UNIT = ".resource.common.monitor.visibility.metricRange.unit";
    public static final String PREF_METRIC_RANGE_RO = ".resource.common.monitor.visibility.metricRange.ro";
    public static final String PREF_METRIC_THRESHOLD = ".resource.common.monitor.visibility.metricThreshold";
    public static final Boolean DEFAULT_VALUE_RANGE_RO = Boolean.FALSE;
    public static final Integer DEFAULT_VALUE_RANGE_LASTN = 8;
    public static final Integer DEFAULT_VALUE_RANGE_UNIT = 3;
    public static final String PREF_MEASUREMENT_INDICATOR_VIEW_PREFIX = "monitor.visibility.indicator.views.";
    public static final String PREF_MEASUREMENT_INDICATOR_VIEW_DEFAULT = "resource.common.monitor.visibility.defaultview";
    public static final String PREF_MEASUREMENT_INDICATOR_VIEW_DEFAULT_NAME = "Default";

    public MeasurementPreferences(Subject subject) {
        super(subject);
    }

    public MetricRangePreferences getMetricRangePreferences() {
        MetricRangePreferences prefs = new MetricRangePreferences();
        prefs.readOnly = this.getPreference(PREF_METRIC_RANGE_RO, DEFAULT_VALUE_RANGE_RO);
        if (!prefs.readOnly) {
            prefs.lastN = this.getPreference(PREF_METRIC_RANGE_LASTN, DEFAULT_VALUE_RANGE_LASTN);
            prefs.unit = this.getPreference(PREF_METRIC_RANGE_UNIT, DEFAULT_VALUE_RANGE_UNIT);
            List<Long> range = MeasurementUtils.calculateTimeFrame(prefs.lastN, prefs.unit);
            prefs.begin = range.get(0);
            prefs.end = range.get(1);
        } else {
            try {
                List<String> range = this.getPreferenceAsList(PREF_METRIC_RANGE);
                if (range.size() != 2) {
                    range = this.getPreferenceAsList(PREF_METRIC_RANGE, "|");
                }
                if (range.size() == 2) {
                    prefs.begin = new Long(range.get(0));
                    prefs.end = new Long(range.get(1));
                } else {
                    this.useDefaultAsFallback(prefs);
                }
            }
            catch (IllegalArgumentException iae) {
                this.useDefaultAsFallback(prefs);
            }
        }
        return prefs;
    }

    private void useDefaultAsFallback(MetricRangePreferences prefs) {
        List<Long> range = MeasurementUtils.calculateTimeFrame(DEFAULT_VALUE_RANGE_LASTN, DEFAULT_VALUE_RANGE_UNIT);
        prefs.begin = range.get(0);
        prefs.end = range.get(1);
    }

    public void setMetricRangePreferences(MetricRangePreferences prefs) {
        this.setPreference(PREF_METRIC_RANGE_RO, prefs.readOnly);
        if (prefs.readOnly) {
            this.setPreference(PREF_METRIC_RANGE, Arrays.asList(prefs.begin, prefs.end));
        } else {
            this.setPreference(PREF_METRIC_RANGE_LASTN, prefs.lastN);
            this.setPreference(PREF_METRIC_RANGE_UNIT, prefs.unit);
        }
    }

    public Integer getMetricThresholdPreference() throws IllegalArgumentException {
        return new Integer(this.getPreference(PREF_METRIC_THRESHOLD));
    }

    public void setMetricThresholdPreference(Integer value) throws IllegalArgumentException {
        this.setPreference(PREF_METRIC_THRESHOLD, value);
    }

    public MetricViewsPreferences getMetricViews(String key) {
        MetricViewsPreferences prefs = new MetricViewsPreferences();
        String value = this.getPreference(PREF_MEASUREMENT_INDICATOR_VIEW_PREFIX + key, PREF_MEASUREMENT_INDICATOR_VIEW_DEFAULT_NAME);
        prefs.views = StringUtil.explode((String)value, (String)"|");
        return prefs;
    }

    public void setMetricViews(MetricViewsPreferences prefs, String key) {
        StringBuilder builder = new StringBuilder();
        int index = 0;
        for (String viewName : prefs.views) {
            if (index != 0) {
                builder.append("|");
            }
            builder.append(viewName);
            ++index;
        }
        this.setPreference(PREF_MEASUREMENT_INDICATOR_VIEW_PREFIX + key, builder.toString());
    }

    public String getSelectedView(String key) {
        String value = this.getPreference("monitor.visibility.indicator.views.selected." + key, PREF_MEASUREMENT_INDICATOR_VIEW_DEFAULT_NAME);
        return value;
    }

    public void setSelectedView(String key, String viewName) {
        this.setPreference("monitor.visibility.indicator.views.selected." + key, viewName);
    }

    public MetricViewData getMetricViewData(String context, String viewName) {
        if (viewName == null || "".equals(viewName)) {
            viewName = "default";
        }
        MetricViewData chartPreferences = new MetricViewData();
        String data = this.getPreference(PREF_MEASUREMENT_INDICATOR_VIEW_PREFIX + context + "." + viewName);
        chartPreferences.charts = StringUtil.explode((String)data, (String)"|");
        return chartPreferences;
    }

    public void setMetricViewData(String context, String viewName, MetricViewData prefs) {
        if (viewName == null || "".equals(viewName)) {
            viewName = "default";
        }
        StringBuilder builder = new StringBuilder();
        int index = 0;
        for (String chart : prefs.charts) {
            if (index != 0) {
                builder.append("|");
            }
            builder.append(chart);
            ++index;
        }
        this.setPreference(PREF_MEASUREMENT_INDICATOR_VIEW_PREFIX + context + "." + viewName, builder.toString());
    }

    public void deleteMetricViewData(String context, String viewName) {
        this.unsetPreference(PREF_MEASUREMENT_INDICATOR_VIEW_PREFIX + context + "." + viewName);
    }

    public static class MetricViewData {
        public List<String> charts;
    }

    public static class MetricViewsPreferences {
        public List<String> views;
    }

    public static class MetricRangePreferences {
        public boolean readOnly;
        public int lastN;
        public int unit;
        public Long begin;
        public Long end;

        public String toString() {
            if (this.readOnly) {
                return this.getClass().getSimpleName() + "[begin=" + this.begin + this.end + ",end=" + this.end + "]";
            }
            return this.getClass().getSimpleName() + "[lastN=" + this.lastN + ",unit=" + this.unit + "]";
        }
    }
}

