/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.perspective.activator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.authz.Permission;
import org.rhq.core.domain.measurement.MeasurementDataTrait;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceTypeFacet;
import org.rhq.enterprise.server.measurement.MeasurementDataManagerLocal;
import org.rhq.enterprise.server.perspective.activator.Activator;
import org.rhq.enterprise.server.perspective.activator.FacetActivator;
import org.rhq.enterprise.server.perspective.activator.GlobalPermissionActivator;
import org.rhq.enterprise.server.perspective.activator.InventoryActivator;
import org.rhq.enterprise.server.perspective.activator.LicenseFeature;
import org.rhq.enterprise.server.perspective.activator.LicenseFeatureActivator;
import org.rhq.enterprise.server.perspective.activator.ResourceConditionSet;
import org.rhq.enterprise.server.perspective.activator.ResourcePermissionActivator;
import org.rhq.enterprise.server.perspective.activator.ResourceTypeActivator;
import org.rhq.enterprise.server.perspective.activator.SuperuserActivator;
import org.rhq.enterprise.server.perspective.activator.TraitActivator;
import org.rhq.enterprise.server.util.LookupUtil;
import org.rhq.enterprise.server.xmlschema.generated.serverplugin.perspective.CommonActivatorsType;
import org.rhq.enterprise.server.xmlschema.generated.serverplugin.perspective.DebugModeActivatorType;
import org.rhq.enterprise.server.xmlschema.generated.serverplugin.perspective.FacetActivatorType;
import org.rhq.enterprise.server.xmlschema.generated.serverplugin.perspective.GlobalActivatorsType;
import org.rhq.enterprise.server.xmlschema.generated.serverplugin.perspective.GlobalPermissionActivatorType;
import org.rhq.enterprise.server.xmlschema.generated.serverplugin.perspective.InventoryActivatorType;
import org.rhq.enterprise.server.xmlschema.generated.serverplugin.perspective.LicenseFeatureActivatorType;
import org.rhq.enterprise.server.xmlschema.generated.serverplugin.perspective.ResourceActivatorsType;
import org.rhq.enterprise.server.xmlschema.generated.serverplugin.perspective.ResourcePermissionActivatorType;
import org.rhq.enterprise.server.xmlschema.generated.serverplugin.perspective.ResourceType;
import org.rhq.enterprise.server.xmlschema.generated.serverplugin.perspective.SuperuserActivatorType;
import org.rhq.enterprise.server.xmlschema.generated.serverplugin.perspective.TraitActivatorType;

public class ActivatorHelper {
    private static final Log LOG = LogFactory.getLog(ActivatorHelper.class);

    public static boolean areTraitsSatisfied(Subject subject, Map<String, Matcher> traitMatchers, Collection<Resource> resources, boolean matchAll) {
        if (traitMatchers.isEmpty()) {
            return true;
        }
        MeasurementDataManagerLocal measurementDataManager = LookupUtil.getMeasurementDataManager();
        for (Resource resource : resources) {
            boolean traitsSatisfied = true;
            List<MeasurementDataTrait> traits = measurementDataManager.findCurrentTraitsForResource(subject, resource.getId(), null);
            int numTraitsTested = 0;
            for (MeasurementDataTrait trait : traits) {
                Matcher traitMatcher = traitMatchers.get(trait.getName());
                if (null == traitMatcher) continue;
                ++numTraitsTested;
                traitMatcher.reset(trait.getValue());
                if (traitMatcher.find()) continue;
                traitsSatisfied = false;
                break;
            }
            if (traitsSatisfied) {
                if (numTraitsTested != traitMatchers.size()) {
                    if (LOG.isDebugEnabled()) {
                        String error = "Potential error in perspective descriptor. Not all trait activators matched trait for resource type: " + traitMatchers.keySet() + " Or, Trait value may not yet have been collected for resource.";
                        LOG.debug((Object)error);
                    }
                    return false;
                }
                if (matchAll) continue;
                return true;
            }
            if (!matchAll) continue;
            return false;
        }
        return matchAll;
    }

    public static boolean initCommonActivators(CommonActivatorsType rawActivators, List<Activator<?>> activators) {
        boolean debugMode = false;
        if (rawActivators == null) {
            return debugMode;
        }
        DebugModeActivatorType rawDebugModeActivator = rawActivators.getDebugMode();
        if (rawDebugModeActivator != null) {
            debugMode = true;
        }
        List rawLicenseFeatures = rawActivators.getLicenseFeature();
        for (LicenseFeatureActivatorType rawLicenseFeature : rawLicenseFeatures) {
            String rawName = rawLicenseFeature.getName().value();
            LicenseFeature licenseFeature = LicenseFeature.valueOf(rawName.toUpperCase(Locale.US));
            LicenseFeatureActivator licenseFeatureActivator = new LicenseFeatureActivator(licenseFeature);
            activators.add(licenseFeatureActivator);
        }
        SuperuserActivatorType rawSuperuserActivator = rawActivators.getSuperuser();
        if (rawSuperuserActivator != null) {
            SuperuserActivator superuserActivator = new SuperuserActivator();
            activators.add(superuserActivator);
        }
        List rawGlobalPermissionActivators = rawActivators.getGlobalPermission();
        for (GlobalPermissionActivatorType rawGlobalPermissionActivator : rawGlobalPermissionActivators) {
            String rawName = rawGlobalPermissionActivator.getName().value();
            Permission permission = Permission.valueOf((String)rawName.toUpperCase(Locale.US));
            GlobalPermissionActivator globalPermissionActivator = new GlobalPermissionActivator(permission);
            activators.add(globalPermissionActivator);
        }
        return debugMode;
    }

    public static boolean initGlobalActivators(GlobalActivatorsType rawActivators, List<Activator<?>> activators) {
        if (rawActivators == null) {
            return false;
        }
        boolean debugMode = ActivatorHelper.initCommonActivators((CommonActivatorsType)rawActivators, activators);
        List rawInventoryActivators = rawActivators.getInventory();
        for (InventoryActivatorType rawInventoryActivator : rawInventoryActivators) {
            List rawResourceConditions = rawInventoryActivator.getResource();
            ArrayList<ResourceConditionSet> resourceConditionSets = new ArrayList<ResourceConditionSet>(rawResourceConditions.size());
            for (ResourceType rawResourceCondition : rawResourceConditions) {
                List rawPermissions = rawResourceCondition.getResourcePermission();
                EnumSet<Permission> permissions = EnumSet.noneOf(Permission.class);
                for (ResourcePermissionActivatorType rawPermission : rawPermissions) {
                    String rawName = rawPermission.getName().toString();
                    Permission permission = Permission.valueOf((String)rawName.toUpperCase(Locale.US));
                    permissions.add(permission);
                }
                List rawTraits = rawResourceCondition.getTrait();
                HashMap<String, Pattern> traits = new HashMap<String, Pattern>();
                for (TraitActivatorType rawTraitActivator : rawTraits) {
                    String name = rawTraitActivator.getName();
                    String value = rawTraitActivator.getValue();
                    traits.put(name, Pattern.compile(value));
                }
                ResourceConditionSet resourceConditionSet = new ResourceConditionSet(rawResourceCondition.getPlugin(), rawResourceCondition.getType(), permissions, traits);
                resourceConditionSets.add(resourceConditionSet);
            }
            InventoryActivator resourceTypeActivator = new InventoryActivator(resourceConditionSets);
            activators.add(resourceTypeActivator);
        }
        return debugMode;
    }

    public static boolean initResourceActivators(ResourceActivatorsType rawActivators, List<Activator<?>> activators) {
        if (rawActivators == null) {
            return false;
        }
        boolean debugMode = ActivatorHelper.initCommonActivators((CommonActivatorsType)rawActivators, activators);
        List rawFacetActivators = rawActivators.getFacet();
        for (FacetActivatorType rawFacetActivator : rawFacetActivators) {
            String rawName = rawFacetActivator.getName().toString();
            FacetActivator facetActivator = new FacetActivator(ResourceTypeFacet.valueOf((String)rawName.toUpperCase(Locale.US)));
            activators.add(facetActivator);
        }
        List rawResourcePermissionActivators = rawActivators.getResourcePermission();
        for (ResourcePermissionActivatorType rawResourcePermissionActivator : rawResourcePermissionActivators) {
            String rawName = rawResourcePermissionActivator.getName().toString();
            Permission permission = Permission.valueOf((String)rawName.toUpperCase(Locale.US));
            ResourcePermissionActivator resourcePermissionActivator = new ResourcePermissionActivator(permission);
            activators.add(resourcePermissionActivator);
        }
        List rawTraitActivators = rawActivators.getTrait();
        for (TraitActivatorType rawTraitActivator : rawTraitActivators) {
            String name = rawTraitActivator.getName();
            String value = rawTraitActivator.getValue();
            TraitActivator traitActivator = new TraitActivator(name, Pattern.compile(value));
            activators.add(traitActivator);
        }
        List rawInventoryActivators = rawActivators.getResourceType();
        for (InventoryActivatorType rawInventoryActivator : rawInventoryActivators) {
            List rawResourceConditions = rawInventoryActivator.getResource();
            ArrayList<ResourceConditionSet> resourceConditionSets = new ArrayList<ResourceConditionSet>(rawResourceConditions.size());
            for (ResourceType rawResourceCondition : rawResourceConditions) {
                List rawPermissions = rawResourceCondition.getResourcePermission();
                EnumSet<Permission> permissions = EnumSet.noneOf(Permission.class);
                for (ResourcePermissionActivatorType rawPermission : rawPermissions) {
                    String rawName = rawPermission.getName().toString();
                    Permission permission = Permission.valueOf((String)rawName.toUpperCase(Locale.US));
                    permissions.add(permission);
                }
                List rawTraits = rawResourceCondition.getTrait();
                HashMap<String, Pattern> traits = new HashMap<String, Pattern>();
                for (TraitActivatorType rawTraitActivator : rawTraits) {
                    String name = rawTraitActivator.getName();
                    String value = rawTraitActivator.getValue();
                    traits.put(name, Pattern.compile(value));
                }
                ResourceConditionSet resourceConditionSet = new ResourceConditionSet(rawResourceCondition.getPlugin(), rawResourceCondition.getType(), permissions, traits);
                resourceConditionSets.add(resourceConditionSet);
            }
            ResourceTypeActivator resourceTypeActivator = new ResourceTypeActivator(resourceConditionSets);
            activators.add(resourceTypeActivator);
        }
        return debugMode;
    }
}

