/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.sync;

import java.util.HashSet;
import java.util.Set;
import javax.persistence.EntityManager;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.measurement.MeasurementDefinition;
import org.rhq.core.domain.sync.entity.MetricTemplate;
import org.rhq.enterprise.server.measurement.MeasurementDefinitionManagerLocal;
import org.rhq.enterprise.server.measurement.MeasurementScheduleManagerLocal;
import org.rhq.enterprise.server.resource.metadata.PluginManagerLocal;
import org.rhq.enterprise.server.sync.Synchronizer;
import org.rhq.enterprise.server.sync.exporters.Exporter;
import org.rhq.enterprise.server.sync.exporters.MetricTemplateExporter;
import org.rhq.enterprise.server.sync.importers.Importer;
import org.rhq.enterprise.server.sync.importers.MetricTemplateImporter;
import org.rhq.enterprise.server.sync.validators.ConsistencyValidator;
import org.rhq.enterprise.server.sync.validators.DeployedAgentPluginsValidator;
import org.rhq.enterprise.server.sync.validators.MetricTemplateValidator;
import org.rhq.enterprise.server.util.LookupUtil;

public class MetricTemplateSynchronizer
implements Synchronizer<MeasurementDefinition, MetricTemplate> {
    private Subject subject;
    private EntityManager entityManager;
    private MeasurementDefinitionManagerLocal measurementDefinitionManager;
    private MeasurementScheduleManagerLocal measurementScheduleManager;
    private PluginManagerLocal pluginManager;

    public MetricTemplateSynchronizer() {
        this(LookupUtil.getMeasurementDefinitionManager(), LookupUtil.getMeasurementScheduleManager(), LookupUtil.getPluginManager());
    }

    public MetricTemplateSynchronizer(MeasurementDefinitionManagerLocal measurementDefinitionManager, MeasurementScheduleManagerLocal measurementScheduleManager, PluginManagerLocal pluginManager) {
        this.measurementDefinitionManager = measurementDefinitionManager;
        this.measurementScheduleManager = measurementScheduleManager;
        this.pluginManager = pluginManager;
    }

    @Override
    public void initialize(Subject subject, EntityManager entityManager) {
        this.subject = subject;
        this.entityManager = entityManager;
    }

    @Override
    public Exporter<MeasurementDefinition, MetricTemplate> getExporter() {
        return new MetricTemplateExporter(this.subject, this.measurementDefinitionManager);
    }

    @Override
    public Importer<MeasurementDefinition, MetricTemplate> getImporter() {
        return new MetricTemplateImporter(this.subject, this.entityManager, this.measurementScheduleManager);
    }

    @Override
    public Set<ConsistencyValidator> getRequiredValidators() {
        HashSet<ConsistencyValidator> ret = new HashSet<ConsistencyValidator>();
        ret.add(new DeployedAgentPluginsValidator(this.pluginManager));
        ret.add(new MetricTemplateValidator());
        return ret;
    }
}

