/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.sync.validators;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.xml.stream.XMLStreamException;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.plugin.Plugin;
import org.rhq.core.domain.plugin.PluginDeploymentType;
import org.rhq.enterprise.server.resource.metadata.PluginManagerLocal;
import org.rhq.enterprise.server.sync.ExportReader;
import org.rhq.enterprise.server.sync.ExportWriter;
import org.rhq.enterprise.server.sync.ValidationException;
import org.rhq.enterprise.server.sync.validators.ConsistencyValidator;
import org.rhq.enterprise.server.sync.validators.InconsistentStateException;
import org.rhq.enterprise.server.util.LookupUtil;

public class DeployedAgentPluginsValidator
implements ConsistencyValidator {
    private PluginManagerLocal pluginManager;
    private Set<ConsistentPlugin> pluginsToValidate;

    public DeployedAgentPluginsValidator() {
        this(LookupUtil.getPluginManager());
    }

    public DeployedAgentPluginsValidator(PluginManagerLocal pluginManager) {
        this.pluginManager = pluginManager;
    }

    public Set<ConsistentPlugin> getPluginsToValidate() {
        return this.pluginsToValidate;
    }

    public void setPluginsToValidate(Set<ConsistentPlugin> pluginsToValidate) {
        this.pluginsToValidate = pluginsToValidate;
    }

    @Override
    public void initialize(Subject subject, EntityManager entityManager) {
    }

    @Override
    public void exportState(ExportWriter writer) throws XMLStreamException {
        List<Plugin> plugins = this.pluginManager.getInstalledPlugins();
        for (Plugin plugin : plugins) {
            if (plugin.getDeployment() != PluginDeploymentType.AGENT) continue;
            writer.writeStartElement("plugin");
            writer.writeAttribute("name", plugin.getName());
            writer.writeAttribute("hash", plugin.getMd5());
            writer.writeAttribute("version", plugin.getVersion());
            writer.writeEndElement();
        }
    }

    @Override
    public void initializeExportedStateValidation(ExportReader reader) throws XMLStreamException {
        this.pluginsToValidate = new HashSet<ConsistentPlugin>();
        while (reader.hasNext()) {
            switch (reader.next()) {
                case 1: {
                    if ("plugin".equals(reader.getName().getLocalPart())) {
                        ConsistentPlugin p = new ConsistentPlugin();
                        p.setName(reader.getAttributeValue(null, "name"));
                        p.setMd5(reader.getAttributeValue(null, "hash"));
                        p.setVersion(reader.getAttributeValue(null, "version"));
                        this.pluginsToValidate.add(p);
                        break;
                    }
                    throw new XMLStreamException("Illegal tag encountered in the DeployedAgentPluginsValidator section: " + reader.getName() + " on location: " + reader.getLocation());
                }
            }
        }
    }

    @Override
    public void validateExportedState() throws InconsistentStateException {
        List<Plugin> localPlugins = this.pluginManager.getInstalledPlugins();
        HashSet<ConsistentPlugin> localAgentPlugins = new HashSet<ConsistentPlugin>();
        for (Plugin p : localPlugins) {
            if (p.getDeployment() != PluginDeploymentType.AGENT) continue;
            localAgentPlugins.add(new ConsistentPlugin(p));
        }
        if (localAgentPlugins.size() != this.pluginsToValidate.size()) {
            DeployedAgentPluginsValidator.throwIncosistentException(localAgentPlugins, this.pluginsToValidate);
        }
        for (ConsistentPlugin localPlugin : localAgentPlugins) {
            if (this.pluginsToValidate.contains((Object)localPlugin)) continue;
            DeployedAgentPluginsValidator.throwIncosistentException(localAgentPlugins, this.pluginsToValidate);
        }
    }

    @Override
    public Set<Class<?>> getValidatedEntityTypes() {
        return Collections.emptySet();
    }

    @Override
    public void validateExportedEntity(Object entity) throws ValidationException {
    }

    @Override
    public int hashCode() {
        return 0;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        return obj instanceof DeployedAgentPluginsValidator;
    }

    private static void throwIncosistentException(Collection<ConsistentPlugin> localPlugins, Collection<ConsistentPlugin> expectedPlugins) throws InconsistentStateException {
        StringBuilder bld = new StringBuilder("Installed plugins are not consistent with the plugins required by the export.");
        bld.append(" The export expects these plugins to be deployed: ");
        DeployedAgentPluginsValidator.appendPlugins(bld, expectedPlugins);
        bld.append(". But the following plugins were found in the local installation: ");
        DeployedAgentPluginsValidator.appendPlugins(bld, localPlugins);
        throw new InconsistentStateException(bld.toString());
    }

    private static void appendPlugins(StringBuilder bld, Collection<ConsistentPlugin> plugins) {
        bld.append("[");
        int size = plugins.size();
        int i = 0;
        for (ConsistentPlugin p : plugins) {
            DeployedAgentPluginsValidator.appendPlugin(bld, p);
            if (++i >= size) continue;
            bld.append(", ");
        }
        bld.append("]");
    }

    private static void appendPlugin(StringBuilder bld, Plugin p) {
        bld.append("Plugin[name='").append(p.getName()).append("'");
        bld.append(", version='").append(p.getVersion()).append("'");
        bld.append(", md5='").append(p.getMd5()).append("']");
    }

    public static class ConsistentPlugin
    extends Plugin {
        private static final long serialVersionUID = 1L;

        public ConsistentPlugin() {
        }

        public ConsistentPlugin(Plugin p) {
            this.setName(p.getName());
            this.setVersion(p.getVersion());
            this.setMd5(p.getMd5());
        }

        public int hashCode() {
            return this.getName().hashCode() * this.getVersion().hashCode() * this.getMd5().hashCode();
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ConsistentPlugin)) {
                return false;
            }
            ConsistentPlugin p = (ConsistentPlugin)((Object)other);
            return this.getName().equals(p.getName()) && this.getVersion().equals(p.getVersion()) && this.getMd5().equals(p.getMd5());
        }
    }
}

