/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.sync.validators;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.xml.stream.XMLStreamException;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.measurement.MeasurementDefinition;
import org.rhq.core.domain.sync.entity.MetricTemplate;
import org.rhq.enterprise.server.sync.ExportReader;
import org.rhq.enterprise.server.sync.ExportWriter;
import org.rhq.enterprise.server.sync.ValidationException;
import org.rhq.enterprise.server.sync.validators.ConsistencyValidator;
import org.rhq.enterprise.server.sync.validators.InconsistentStateException;

public class MetricTemplateValidator
implements ConsistencyValidator {
    private EntityManager entityManager;
    private Set<MetricTemplate> allMeasurementDefinitions;
    private Set<MetricTemplate> alreadyCheckedTemplates;
    private boolean dataInitialized = false;

    @Override
    public void initialize(Subject subject, EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    @Override
    public void exportState(ExportWriter writer) throws XMLStreamException {
    }

    @Override
    public void initializeExportedStateValidation(ExportReader reader) throws XMLStreamException {
    }

    @Override
    public void validateExportedState() throws InconsistentStateException {
    }

    @Override
    public Set<Class<?>> getValidatedEntityTypes() {
        return Collections.singleton(MetricTemplate.class);
    }

    @Override
    public void validateExportedEntity(Object entity) throws ValidationException {
        this.initializeData();
        MetricTemplate template = (MetricTemplate)entity;
        if (!this.allMeasurementDefinitions.contains(template)) {
            throw new ValidationException("The metric template " + template + " does not have any corresponding metric template in the database. This either means that the source of the export had different plugins installed, the export file has been manually edited to contain this inconsistency or that the database is corrupted.");
        }
        if (!this.alreadyCheckedTemplates.add(template)) {
            throw new ValidationException("Was the export file manually updated? The metric template " + template + " has been seen multiple times.");
        }
    }

    private void initializeData() {
        if (this.dataInitialized) {
            return;
        }
        this.allMeasurementDefinitions = new HashSet<MetricTemplate>();
        this.alreadyCheckedTemplates = new HashSet<MetricTemplate>();
        Query q = this.entityManager.createQuery("SELECT md FROM MeasurementDefinition md");
        for (Object r : q.getResultList()) {
            MeasurementDefinition md = (MeasurementDefinition)r;
            this.allMeasurementDefinitions.add(new MetricTemplate(md));
        }
        this.dataInitialized = true;
    }

    @Override
    public int hashCode() {
        return 0;
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof MetricTemplateValidator;
    }
}

