/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.client;

import gnu.getopt.Getopt;
import gnu.getopt.LongOpt;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StreamTokenizer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import jline.ArgumentCompletor;
import jline.Completor;
import jline.ConsoleReader;
import jline.MultiCompletor;
import jline.SimpleCompletor;
import mazz.i18n.Msg;
import org.rhq.core.domain.auth.Subject;
import org.rhq.enterprise.client.ClientI18NFactory;
import org.rhq.enterprise.client.InteractiveJavascriptCompletor;
import org.rhq.enterprise.client.NoOpRecorder;
import org.rhq.enterprise.client.Recorder;
import org.rhq.enterprise.client.RemoteClient;
import org.rhq.enterprise.client.Version;
import org.rhq.enterprise.client.commands.ClientCommand;
import org.rhq.enterprise.client.commands.ScriptCommand;

public class ClientMain {
    private static final Msg MSG = ClientI18NFactory.getMsg();
    private static Map<String, ClientCommand> commands = new HashMap<String, ClientCommand>();
    private Thread inputLoopThread;
    private BufferedReader inputReader;
    private ConsoleReader consoleReader;
    private boolean stdinInput = true;
    private PrintWriter outputWriter;
    private String transport = null;
    private String host = null;
    private int port = 7080;
    private String user;
    private String pass;
    private ArrayList<String> notes = new ArrayList();
    private RemoteClient remoteClient;
    private Subject subject;
    private InteractiveJavascriptCompletor serviceCompletor;
    private boolean interactiveMode = true;
    private Recorder recorder = new NoOpRecorder();

    public static void main(String[] args) throws Exception {
        ClientMain.initCommands();
        ClientMain main = new ClientMain();
        main.processArguments(args);
        if (main.interactiveMode) {
            main.inputLoop();
        }
    }

    private static void initCommands() {
        for (Class<ClientCommand> commandClass : ClientCommand.COMMANDS) {
            ClientCommand command = null;
            try {
                command = commandClass.newInstance();
                commands.put(command.getPromptCommandString(), command);
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }

    private void initScriptCommandAndServiceCompletor() {
        ScriptCommand sc = (ScriptCommand)commands.get("exec");
        sc.initBindings(this);
        this.serviceCompletor.setContext(sc.getContext());
        if (this.remoteClient != null) {
            this.serviceCompletor.setServices(this.remoteClient.getManagers());
        }
    }

    public ClientMain() throws Exception {
        this.outputWriter = new PrintWriter(System.out, true);
        this.consoleReader = new ConsoleReader();
        SimpleCompletor commandCompletor = new SimpleCompletor(commands.keySet().toArray(new String[commands.size()]));
        ArgumentCompletor helpCompletor = new ArgumentCompletor(new Completor[]{new SimpleCompletor("help"), new SimpleCompletor(commands.keySet().toArray(new String[commands.size()]))});
        this.serviceCompletor = new InteractiveJavascriptCompletor(this.consoleReader);
        this.consoleReader.addCompletor((Completor)new MultiCompletor(new Completor[]{this.serviceCompletor, helpCompletor, commandCompletor}));
        this.initScriptCommandAndServiceCompletor();
        this.consoleReader.setUsePagination(true);
    }

    public void start() {
        this.outputWriter = new PrintWriter(System.out);
    }

    public String getUserInput(String prompt) {
        boolean use_default_prompt;
        String input_string = "";
        boolean bl = use_default_prompt = prompt == null;
        while (input_string != null && input_string.trim().length() == 0) {
            if (prompt == null) {
                if (!this.loggedIn()) {
                    prompt = "unconnected$ ";
                } else {
                    String loggedInUser = "";
                    if (this.getSubject() != null && this.getSubject().getName() != null) {
                        loggedInUser = this.getSubject().getName();
                    }
                    prompt = loggedInUser.trim().length() > 0 ? loggedInUser + "@" + this.host + ":" + this.port + "$ " : this.host + ":" + this.port + "$ ";
                }
            }
            try {
                this.outputWriter.flush();
                input_string = this.consoleReader.readLine(prompt);
            }
            catch (Exception e) {
                input_string = null;
            }
        }
        if (input_string != null) {
            if (!this.stdinInput) {
                this.outputWriter.println(input_string);
            }
        } else if (!this.stdinInput) {
            try {
                this.inputReader.close();
            }
            catch (IOException e1) {
                // empty catch block
            }
        }
        return input_string;
    }

    public ConsoleReader getConsoleReader() {
        return this.consoleReader;
    }

    public boolean loggedIn() {
        return this.subject != null && this.remoteClient != null && this.remoteClient.isLoggedIn();
    }

    private void inputLoop() {
        Runnable loop_runnable = new Runnable(){

            @Override
            public void run() {
                while (true) {
                    String cmd = ClientMain.this.getUserInput(null);
                    try {
                        ClientMain.this.recorder.record(cmd);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    try {
                        String[] cmd_args = ClientMain.this.parseCommandLine(cmd);
                        boolean can_continue = ClientMain.this.executePromptCommand(cmd_args);
                        if (can_continue) continue;
                    }
                    catch (Throwable t) {
                        t.printStackTrace(ClientMain.this.outputWriter);
                        continue;
                    }
                    break;
                }
            }
        };
        this.inputLoopThread = new Thread(loop_runnable);
        this.inputLoopThread.setName("RHQ Client Prompt Input Thread");
        this.inputLoopThread.setDaemon(false);
        this.inputLoopThread.start();
    }

    public boolean executePromptCommand(String[] args) throws Exception {
        String cmd = args[0];
        if (commands.containsKey(cmd)) {
            ClientCommand command = commands.get(cmd);
            if (this.shouldDisplayHelp(args)) {
                this.outputWriter.println("syntax: " + command.getSyntax());
                this.outputWriter.println("description: " + command.getHelp() + "\n");
                return true;
            }
            if (this.shouldDisplayDetailedHelp(args)) {
                this.outputWriter.println("syntax: " + command.getSyntax());
                this.outputWriter.println("description: " + command.getDetailedHelp() + "\n");
                return true;
            }
            try {
                boolean response = command.execute(this, args);
                this.processNotes(this.outputWriter);
                this.outputWriter.println("");
                return response;
            }
            catch (ArrayIndexOutOfBoundsException e) {
                this.outputWriter.println("An incorrect number of arguments was specified.");
                this.outputWriter.println("Expected syntax: " + command.getSyntax());
            }
        } else {
            boolean result = commands.get("exec").execute(this, args);
            if (this.loggedIn()) {
                this.serviceCompletor.setContext(((ScriptCommand)commands.get("exec")).getContext());
            }
            return result;
        }
        return true;
    }

    private boolean shouldDisplayHelp(String[] args) {
        if (args.length < 2) {
            return false;
        }
        return args[1].equals("-h");
    }

    private boolean shouldDisplayDetailedHelp(String[] args) {
        if (args.length < 2) {
            return false;
        }
        return args[1].equals("--help");
    }

    private void processNotes(PrintWriter outputWriter2) {
        if (outputWriter2 != null && this.notes.size() > 0) {
            for (String line : this.notes) {
                outputWriter2.println("-> " + line);
            }
            this.notes.clear();
        }
    }

    public String[] parseCommandLine(String cmdLine) {
        if (cmdLine == null) {
            return new String[]{""};
        }
        ByteArrayInputStream in = new ByteArrayInputStream(cmdLine.getBytes());
        StreamTokenizer strtok = new StreamTokenizer(new InputStreamReader(in));
        ArrayList<String> args = new ArrayList<String>();
        boolean keep_going = true;
        strtok.ordinaryChars(48, 57);
        strtok.ordinaryChar(46);
        strtok.ordinaryChar(45);
        strtok.ordinaryChar(39);
        strtok.wordChars(33, 127);
        while (keep_going) {
            int nextToken;
            try {
                nextToken = strtok.nextToken();
            }
            catch (IOException e) {
                nextToken = -1;
            }
            if (nextToken == -3) {
                args.add(strtok.sval);
                continue;
            }
            if (nextToken == 34) {
                args.add(strtok.sval);
                continue;
            }
            if (nextToken != -1 && nextToken != 10) continue;
            keep_going = false;
        }
        return args.toArray(new String[args.size()]);
    }

    private void displayUsage() {
        this.outputWriter.println("rhq-cli.sh [-h] [-u user] [-p pass] [-P] [-s host] [-t port] [-f file]|[-c command]");
    }

    void processArguments(String[] args) throws IllegalArgumentException, IOException {
        int code;
        String sopts = "-:hu:p:Ps:t:r:c:f:v";
        LongOpt[] lopts = new LongOpt[]{new LongOpt("help", 0, null, 104), new LongOpt("user", 1, null, 117), new LongOpt("password", 1, null, 112), new LongOpt("prompt", 2, null, 80), new LongOpt("host", 1, null, 115), new LongOpt("port", 1, null, 116), new LongOpt("transport", 1, null, 114), new LongOpt("command", 1, null, 99), new LongOpt("file", 0, null, 102), new LongOpt("version", 0, null, 118), new LongOpt("args-style", 1, null, -2)};
        Getopt getopt = new Getopt("Cli", args, sopts, lopts, false);
        ArrayList<String> execCmdLine = new ArrayList<String>();
        execCmdLine.add("exec");
        while ((code = getopt.getopt()) != -1) {
            switch (code) {
                case 58: 
                case 63: {
                    this.displayUsage();
                    throw new IllegalArgumentException(MSG.getMsg("ClientMain.badArgs", new Object[0]));
                }
                case 1: {
                    execCmdLine.add(getopt.getOptarg());
                    break;
                }
                case 104: {
                    this.displayUsage();
                    break;
                }
                case 117: {
                    this.user = getopt.getOptarg();
                    break;
                }
                case 112: {
                    this.pass = getopt.getOptarg();
                    break;
                }
                case 80: {
                    this.pass = this.consoleReader.readLine("password: ", Character.valueOf('\u0000'));
                    break;
                }
                case 99: {
                    this.interactiveMode = false;
                    execCmdLine.add(getopt.getOptarg());
                    break;
                }
                case 102: {
                    this.interactiveMode = false;
                    execCmdLine.add("-f");
                    execCmdLine.add(getopt.getOptarg());
                    break;
                }
                case -2: {
                    execCmdLine.add("--args-style=" + getopt.getOptarg());
                    break;
                }
                case 115: {
                    this.setHost(getopt.getOptarg());
                    break;
                }
                case 114: {
                    this.setTransport(getopt.getOptarg());
                    break;
                }
                case 116: {
                    String portArg = getopt.getOptarg();
                    try {
                        this.setPort(Integer.parseInt(portArg));
                    }
                    catch (Exception e) {
                        this.outputWriter.println("Invalid port [" + portArg + "]");
                    }
                    break;
                }
                case 118: {
                    String versionString = Version.getProductNameAndVersionBuildInfo();
                    this.outputWriter.println(versionString);
                    break;
                }
            }
        }
        if (this.interactiveMode) {
            this.outputWriter.println(Version.getProductNameAndVersion());
        }
        if (this.user != null && this.pass != null) {
            ClientCommand loginCmd = commands.get("login");
            if (this.host != null) {
                loginCmd.execute(this, new String[]{"login", this.user, this.pass, this.host, String.valueOf(this.port), this.transport});
            } else {
                loginCmd.execute(this, new String[]{"login", this.user, this.pass});
            }
            if (!this.loggedIn()) {
                return;
            }
        }
        if (!this.interactiveMode) {
            commands.get("exec").execute(this, execCmdLine.toArray(new String[0]));
        }
    }

    public RemoteClient getRemoteClient() {
        return this.remoteClient;
    }

    public void setRemoteClient(RemoteClient remoteClient) {
        this.remoteClient = remoteClient;
        this.initScriptCommandAndServiceCompletor();
    }

    public Subject getSubject() {
        return this.subject;
    }

    public void setSubject(Subject subject) {
        this.subject = subject;
    }

    public String getTransport() {
        return this.transport;
    }

    public void setTransport(String transport) {
        this.transport = transport;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPass() {
        return this.pass;
    }

    public void setPass(String pass) {
        this.pass = pass;
    }

    public PrintWriter getPrintWriter() {
        return this.outputWriter;
    }

    public void setPrintWriter(PrintWriter writer) {
        this.outputWriter = writer;
    }

    public int getConsoleWidth() {
        return this.consoleReader.getTermwidth();
    }

    public Map<String, ClientCommand> getCommands() {
        return commands;
    }

    public void addMenuNote(String note) {
        if (note != null && note.trim().length() > 0) {
            this.notes.add(note);
        }
    }

    public boolean isInteractiveMode() {
        return this.interactiveMode;
    }

    public Recorder getRecorder() {
        return this.recorder;
    }

    public void setRecorder(Recorder recorder) {
        this.recorder = recorder;
    }
}

