/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.communications.util;

import java.io.File;
import java.util.Arrays;
import mazz.i18n.Logger;
import org.rhq.enterprise.communications.command.impl.start.StartCommand;
import org.rhq.enterprise.communications.command.impl.start.StartCommandResponse;
import org.rhq.enterprise.communications.command.impl.start.server.ProcessExec;
import org.rhq.enterprise.communications.i18n.CommI18NFactory;

public class SecurityUtil {
    private static final Logger LOG = CommI18NFactory.getLogger(SecurityUtil.class);

    private SecurityUtil() {
    }

    public static boolean isTransportSecure(String transport) {
        return transport.startsWith("ssl") || transport.startsWith("https");
    }

    public static void createKeyStore(String file_path, String key_alias, String domain_name, String keystore_password, String key_password, String key_algorithm, int validity) throws RuntimeException {
        boolean success;
        File keystore = new File(file_path);
        if (keystore.exists()) {
            LOG.debug("SecurityUtil.keystore-exists", new Object[]{keystore});
            return;
        }
        if (validity <= 0) {
            validity = 36500;
        }
        if (keystore_password == null) {
            throw new RuntimeException(LOG.getMsgString("SecurityUtil.keystore-password-null", new Object[0]));
        }
        if (key_password == null || key_password.length() == 0) {
            LOG.debug("SecurityUtil.key-password-unspecified", new Object[]{keystore});
            key_password = keystore_password;
        }
        if (keystore_password.length() < 6) {
            throw new RuntimeException(LOG.getMsgString("SecurityUtil.keystore-password-not-long-enough", new Object[0]));
        }
        if (key_password.length() < 6) {
            throw new RuntimeException(LOG.getMsgString("SecurityUtil.key-password-not-long-enough", new Object[0]));
        }
        File keystore_dir = keystore.getParentFile();
        if (keystore_dir != null && !keystore_dir.exists() && !(success = keystore_dir.mkdirs())) {
            throw new RuntimeException(LOG.getMsgString("SecurityUtil.cannot-create-keystore-dir", new Object[]{keystore_dir}));
        }
        String keytool_dir = System.getProperty("java.home") + File.separator + "bin";
        String keytool_exe = System.getProperty("os.name").toLowerCase().startsWith("windows") ? "keytool.exe" : "keytool";
        StartCommand keytool_cmd = new StartCommand();
        keytool_cmd.setProgramDirectory(keytool_dir);
        keytool_cmd.setProgramExecutable(keytool_exe);
        keytool_cmd.setWaitForExit(30000L);
        keytool_cmd.setCaptureOutput(Boolean.FALSE);
        keytool_cmd.setCommandInResponse(true);
        keytool_cmd.setArguments(new String[]{"-genkey", "-alias", key_alias, "-dname", domain_name, "-keystore", keystore.getAbsolutePath(), "-storepass", keystore_password, "-keypass", key_password, "-keyalg", key_algorithm, "-validity", Integer.toString(validity)});
        StartCommandResponse keytool_results = new ProcessExec().execute(keytool_cmd);
        if (!keytool_results.isSuccessful() || !keystore.exists()) {
            throw new RuntimeException(LOG.getMsgString("SecurityUtil.keystore-creation-failure", new Object[]{keytool_results, Arrays.asList(keytool_cmd.getArguments()).toString()}), keytool_results.getException());
        }
        LOG.debug("SecurityUtil.keystore-created", new Object[]{keystore.getAbsolutePath()});
    }
}

