/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.bindings;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.MethodDescriptor;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.bindings.StandardBindings;
import org.rhq.bindings.engine.JsEngineInitializer;
import org.rhq.bindings.engine.ScriptEngineInitializer;
import org.rhq.bindings.util.NoTopLevelIndirection;
import org.rhq.bindings.util.PackageFinder;

public class ScriptEngineFactory {
    private static final Log LOG = LogFactory.getLog(ScriptEngineFactory.class);
    private static final ScriptEngineInitializer[] KNOWN_ENGINES = new ScriptEngineInitializer[]{new JsEngineInitializer()};

    private ScriptEngineFactory() {
    }

    public static ScriptEngine getScriptEngine(String language, PackageFinder packageFinder, StandardBindings bindings) throws ScriptException, IOException {
        ScriptEngineInitializer initializer = ScriptEngineFactory.getInitializer(language);
        if (initializer == null) {
            return null;
        }
        ScriptEngine engine = initializer.instantiate(packageFinder.findPackages("org.rhq.core.domain"));
        if (bindings != null) {
            ScriptEngineFactory.injectStandardBindings(engine, bindings, true);
        }
        return engine;
    }

    public static void injectStandardBindings(ScriptEngine engine, StandardBindings bindings, boolean deleteExistingBindings) {
        bindings.preInject(engine);
        Bindings engineBindings = deleteExistingBindings ? engine.createBindings() : engine.getBindings(100);
        for (Map.Entry entry : bindings.entrySet()) {
            engineBindings.put((String)entry.getKey(), entry.getValue());
        }
        engine.setBindings(engineBindings, 100);
        bindings.postInject(engine);
    }

    public static void bindIndirectionMethods(ScriptEngine scriptEngine, String bindingName) {
        Object object = scriptEngine.get(bindingName);
        if (object == null) {
            LOG.debug((Object)("The script engine doesn't contain a binding called '" + bindingName + "'. No indirection functions will be generated."));
            return;
        }
        ScriptEngineInitializer initializer = ScriptEngineFactory.getInitializer(scriptEngine.getFactory().getLanguageName());
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(object.getClass(), Object.class);
            MethodDescriptor[] methodDescriptors = beanInfo.getMethodDescriptors();
            HashMap<String, HashSet<Method>> overloadsPerMethodName = new HashMap<String, HashSet<Method>>();
            for (MethodDescriptor methodDescriptor : methodDescriptors) {
                Method method = methodDescriptor.getMethod();
                if (!ScriptEngineFactory.shouldIndirect(method)) continue;
                HashSet<Method> overloads = (HashSet<Method>)overloadsPerMethodName.get(method.getName());
                if (overloads == null) {
                    overloads = new HashSet<Method>();
                    overloadsPerMethodName.put(method.getName(), overloads);
                }
                overloads.add(method);
            }
            for (Set overloads : overloadsPerMethodName.values()) {
                Set<String> methodDefs = initializer.generateIndirectionMethods(bindingName, overloads);
                for (String methodDef : methodDefs) {
                    try {
                        scriptEngine.eval(methodDef);
                    }
                    catch (ScriptException e) {
                        LOG.warn((Object)("Unable to define global function declared as:\n" + methodDef), (Throwable)e);
                    }
                }
            }
        }
        catch (IntrospectionException e) {
            LOG.debug((Object)("Could not inspect class " + object.getClass().getName() + ". No indirection methods for variable '" + bindingName + "' will be generated."), (Throwable)e);
        }
    }

    public static ScriptEngineInitializer getInitializer(String language) {
        for (ScriptEngineInitializer i : KNOWN_ENGINES) {
            if (!i.implementsLanguage(language)) continue;
            return i;
        }
        return null;
    }

    private static boolean shouldIndirect(Method method) {
        return method.getAnnotation(NoTopLevelIndirection.class) == null;
    }
}

