/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.bindings;

import java.io.PrintWriter;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.script.ScriptEngine;
import org.rhq.bindings.ScriptEngineFactory;
import org.rhq.bindings.client.ResourceClientFactory;
import org.rhq.bindings.client.RhqFacade;
import org.rhq.bindings.export.Exporter;
import org.rhq.bindings.output.TabularWriter;
import org.rhq.bindings.util.ScriptAssert;
import org.rhq.bindings.util.ScriptUtil;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.util.PageControl;

public class StandardBindings
extends HashMap<String, Object> {
    private static final long serialVersionUID = 1L;
    public static final String UNLIMITED_PC = "unlimitedPC";
    public static final String PAGE_CONTROL = "pageControl";
    public static final String EXPORTER = "exporter";
    public static final String SUBJECT = "subject";
    public static final String PRETTY = "pretty";
    public static final String SCRIPT_UTIL = "scriptUtil";
    public static final String PROXY_FACTORY = "ProxyFactory";
    public static final String ASSERT = "Assert";
    private Map<String, Object> managers;

    public StandardBindings(PrintWriter output, RhqFacade rhqFacade) {
        PageControl pc = new PageControl();
        pc.setPageNumber(-1);
        this.put(UNLIMITED_PC, pc);
        this.put(PAGE_CONTROL, PageControl.getUnlimitedInstance());
        this.put(EXPORTER, new Exporter());
        this.put(PRETTY, new TabularWriter(output));
        this.put(ASSERT, new ScriptAssert());
        this.put(SCRIPT_UTIL, new ScriptUtil(rhqFacade));
        if (rhqFacade != null) {
            this.managers = rhqFacade.getManagers();
            this.put(SUBJECT, rhqFacade.getSubject());
            this.put(PROXY_FACTORY, new ResourceClientFactory(rhqFacade, output));
        } else {
            this.managers = Collections.emptyMap();
            this.put(SUBJECT, null);
            this.put(PROXY_FACTORY, null);
        }
        this.putAll(this.managers);
    }

    public void preInject(ScriptEngine scriptEngine) {
        ((ScriptUtil)this.get(SCRIPT_UTIL)).init(scriptEngine);
        ((ScriptAssert)this.get(ASSERT)).init(scriptEngine);
    }

    public void postInject(ScriptEngine scriptEngine) {
        ScriptEngineFactory.bindIndirectionMethods(scriptEngine, SCRIPT_UTIL);
        ScriptEngineFactory.bindIndirectionMethods(scriptEngine, ASSERT);
    }

    public Map.Entry<String, PageControl> getUnlimitedPC() {
        return this.castEntry(UNLIMITED_PC, PageControl.class);
    }

    public Map.Entry<String, PageControl> getPageControl() {
        return this.castEntry(PAGE_CONTROL, PageControl.class);
    }

    public Map.Entry<String, Exporter> getExporter() {
        return this.castEntry(EXPORTER, Exporter.class);
    }

    public Map.Entry<String, Subject> getSubject() {
        return this.castEntry(SUBJECT, Subject.class);
    }

    public Map.Entry<String, TabularWriter> getPretty() {
        return this.castEntry(PRETTY, TabularWriter.class);
    }

    public Map.Entry<String, ScriptUtil> getScriptUtil() {
        return this.castEntry(SCRIPT_UTIL, ScriptUtil.class);
    }

    public Map.Entry<String, ResourceClientFactory> getProxyFactory() {
        return this.castEntry(PROXY_FACTORY, ResourceClientFactory.class);
    }

    public Map<String, Object> getManagers() {
        return this.managers;
    }

    private Map.Entry<String, Object> getEntry(String key) {
        for (Map.Entry<String, Object> entry : this.entrySet()) {
            if (key == null && entry.getKey() == null) {
                return entry;
            }
            if (!key.equals(entry.getKey())) continue;
            return entry;
        }
        return null;
    }

    private <T> Map.Entry<String, T> castEntry(String key, Class<T> clazz) {
        Map.Entry<String, Object> entry = this.getEntry(key);
        if (entry == null) {
            return null;
        }
        return new CastingEntry<T>(entry, clazz);
    }

    private static class CastingEntry<T>
    implements Map.Entry<String, T> {
        private Map.Entry<String, Object> inner;
        private Class<T> clazz;

        public CastingEntry(Map.Entry<String, Object> inner, Class<T> clazz) {
            this.inner = inner;
            this.clazz = clazz;
        }

        @Override
        public String getKey() {
            return this.inner.getKey();
        }

        @Override
        public T getValue() {
            return this.clazz.cast(this.inner.getValue());
        }

        @Override
        public T setValue(T value) {
            return this.clazz.cast(this.inner.setValue(value));
        }
    }
}

