/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.discovery;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.rhq.core.clientapi.server.discovery.InventoryReport;
import org.rhq.core.domain.criteria.ResourceTypeCriteria;
import org.rhq.core.domain.plugin.Plugin;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.domain.util.PageControl;
import org.rhq.core.domain.util.PageList;
import org.rhq.enterprise.server.auth.SubjectManagerLocal;
import org.rhq.enterprise.server.discovery.InventoryReportFilter;
import org.rhq.enterprise.server.resource.ResourceTypeManagerLocal;
import org.rhq.enterprise.server.resource.metadata.PluginManagerLocal;

public class DeletedResourceTypeFilter
implements InventoryReportFilter {
    private SubjectManagerLocal subjectMgr;
    private ResourceTypeManagerLocal resourceTypeMgr;
    private PluginManagerLocal pluginMgr;
    private Set<String> deletedTypes;
    private Set<String> installedPlugins;

    public DeletedResourceTypeFilter(SubjectManagerLocal subjectManager, ResourceTypeManagerLocal resourceTypeManager, PluginManagerLocal pluginManager) {
        this.subjectMgr = subjectManager;
        this.resourceTypeMgr = resourceTypeManager;
        this.pluginMgr = pluginManager;
        this.deletedTypes = new HashSet<String>();
        this.installedPlugins = new HashSet<String>();
        this.loadDeletedTypes();
        this.loadInstalledPlugins();
    }

    private void loadDeletedTypes() {
        ResourceTypeCriteria criteria = new ResourceTypeCriteria();
        criteria.addFilterDeleted(true);
        criteria.setPageControl(PageControl.getUnlimitedInstance());
        PageList<ResourceType> results = this.resourceTypeMgr.findResourceTypesByCriteria(this.subjectMgr.getOverlord(), criteria);
        for (ResourceType type : results) {
            this.deletedTypes.add(type.getName() + "::" + type.getPlugin());
        }
    }

    private void loadInstalledPlugins() {
        List<Plugin> plugins = this.pluginMgr.getInstalledPlugins();
        for (Plugin plugin : plugins) {
            this.installedPlugins.add(plugin.getName());
        }
    }

    @Override
    public boolean accept(InventoryReport report) {
        Set<ResourceType> resourceTypes = this.getResourceTypes(report.getAddedRoots());
        for (ResourceType type : resourceTypes) {
            if (this.installedPlugins.contains(type.getPlugin()) && !this.deletedTypes.contains(type.getName() + "::" + type.getPlugin())) continue;
            return false;
        }
        return true;
    }

    private Set<ResourceType> getResourceTypes(Set<Resource> resources) {
        HashSet<ResourceType> types = new HashSet<ResourceType>();
        for (Resource resource : resources) {
            types.add(resource.getResourceType());
            types.addAll(this.getResourceTypes(resource.getChildResources()));
        }
        return types;
    }
}

