/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.scheduler.jobs;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.rhq.core.domain.plugin.Plugin;
import org.rhq.enterprise.server.resource.metadata.PluginManagerLocal;
import org.rhq.enterprise.server.scheduler.jobs.AbstractStatefulJob;
import org.rhq.enterprise.server.util.LookupUtil;

public class PurgePluginsJob
extends AbstractStatefulJob {
    private static final Log log = LogFactory.getLog(PurgePluginsJob.class);

    @Override
    public void executeJobCode(JobExecutionContext context) throws JobExecutionException {
        PluginManagerLocal pluginMgr = LookupUtil.getPluginManager();
        List<Plugin> plugins = pluginMgr.findPluginsMarkedForPurge();
        ArrayList<Plugin> pluginsToPurge = new ArrayList<Plugin>();
        for (Plugin plugin : plugins) {
            if (!pluginMgr.isReadyForPurge(plugin)) continue;
            log.debug((Object)("Preparing to purge plugin [" + plugin.getName() + "]"));
            pluginsToPurge.add(plugin);
        }
        if (!pluginsToPurge.isEmpty()) {
            pluginMgr.purgePlugins(pluginsToPurge);
            log.debug((Object)("Purged " + pluginsToPurge.size() + " plugins"));
        }
    }
}

