/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.sync.importers;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.rhq.core.clientapi.agent.configuration.ConfigurationUtility;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.definition.ConfigurationDefinition;
import org.rhq.core.domain.configuration.definition.PropertyDefinition;
import org.rhq.core.domain.configuration.definition.PropertyDefinitionSimple;
import org.rhq.core.domain.configuration.definition.PropertySimpleType;
import org.rhq.core.domain.sync.entity.SystemSettings;
import org.rhq.enterprise.server.sync.ExportReader;
import org.rhq.enterprise.server.sync.NoSingleEntity;
import org.rhq.enterprise.server.sync.importers.ExportedEntityMatcher;
import org.rhq.enterprise.server.sync.importers.Importer;
import org.rhq.enterprise.server.sync.importers.NoSingleEntityMatcher;
import org.rhq.enterprise.server.sync.validators.EntityValidator;
import org.rhq.enterprise.server.sync.validators.MaxCountValidator;
import org.rhq.enterprise.server.sync.validators.SystemSettingsValidator;
import org.rhq.enterprise.server.system.SystemManagerLocal;

public class SystemSettingsImporter
implements Importer<NoSingleEntity, SystemSettings> {
    public static final String PROPERTIES_TO_IMPORT_PROPERTY = "propertiesToImport";
    public static final String DEFAULT_IMPORTED_PROPERTIES_LIST = "AGENT_MAX_QUIET_TIME_ALLOWED, ENABLE_AGENT_AUTO_UPDATE, ENABLE_DEBUG_MODE, ENABLE_EXPERIMENTAL_FEATURES, CAM_DATA_PURGE_1H, CAM_DATA_PURGE_6H, CAM_DATA_PURGE_1D, CAM_DATA_MAINTENANCE, DATA_REINDEX_NIGHTLY, RT_DATA_PURGE, ALERT_PURGE, EVENT_PURGE, TRAIT_PURGE, AVAILABILITY_PURGE, CAM_BASELINE_FREQUENCY, CAM_BASELINE_DATASET";
    private Subject subject;
    private SystemManagerLocal systemManager;
    private Configuration importConfiguration;
    private Unmarshaller unmarshaller;

    public SystemSettingsImporter(Subject subject, SystemManagerLocal systemManager) {
        try {
            this.subject = subject;
            this.systemManager = systemManager;
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{SystemSettings.class});
            this.unmarshaller = context.createUnmarshaller();
        }
        catch (JAXBException e) {
            throw new IllegalStateException("Failed to initialize JAXB marshaller for MetricTemplate.", e);
        }
    }

    @Override
    public ConfigurationDefinition getImportConfigurationDefinition() {
        ConfigurationDefinition def = new ConfigurationDefinition("SystemSettingsConfiguration", null);
        PropertyDefinitionSimple props = new PropertyDefinitionSimple(PROPERTIES_TO_IMPORT_PROPERTY, "The names of the properties that should be imported. Note that these are the INTERNAL names as used in the RHQ database", true, PropertySimpleType.STRING);
        props.setDefaultValue(DEFAULT_IMPORTED_PROPERTIES_LIST);
        def.put((PropertyDefinition)props);
        ConfigurationUtility.initializeDefaultTemplate((ConfigurationDefinition)def);
        return def;
    }

    @Override
    public void configure(Configuration importConfiguration) {
        this.importConfiguration = importConfiguration;
        if (importConfiguration == null) {
            this.importConfiguration = this.getImportConfigurationDefinition().getDefaultTemplate().getConfiguration();
        }
    }

    @Override
    public ExportedEntityMatcher<NoSingleEntity, SystemSettings> getExportedEntityMatcher() {
        return new NoSingleEntityMatcher<SystemSettings>();
    }

    @Override
    public Set<EntityValidator<SystemSettings>> getEntityValidators() {
        HashSet<EntityValidator<SystemSettings>> ret = new HashSet<EntityValidator<SystemSettings>>();
        ret.add(new SystemSettingsValidator());
        ret.add(new MaxCountValidator(1));
        return ret;
    }

    @Override
    public void update(NoSingleEntity entity, SystemSettings exportedEntity) throws Exception {
        Properties props = exportedEntity.toProperties();
        Set<String> propsToImport = this.getSettingNamesConfiguredForImport(this.importConfiguration);
        HashSet<String> propsToRemove = new HashSet<String>();
        for (Object k : props.keySet()) {
            String key = (String)k;
            if (propsToImport.contains(key)) continue;
            propsToRemove.add(key);
        }
        for (String p : propsToRemove) {
            props.remove(p);
        }
        this.systemManager.setSystemConfiguration(this.subject, props, true);
    }

    @Override
    public SystemSettings unmarshallExportedEntity(ExportReader reader) throws XMLStreamException {
        try {
            return (SystemSettings)this.unmarshaller.unmarshal((XMLStreamReader)reader);
        }
        catch (JAXBException e) {
            throw new XMLStreamException("Failed to unmarshal system settings.", e);
        }
    }

    @Override
    public String finishImport() {
        return null;
    }

    private Set<String> getSettingNamesConfiguredForImport(Configuration importConfiguration) {
        String settingsToImport = importConfiguration.getSimpleValue(PROPERTIES_TO_IMPORT_PROPERTY, null);
        if (settingsToImport == null) {
            return Collections.emptySet();
        }
        String[] vals = settingsToImport.split("\\s*,\\s*");
        return new HashSet<String>(Arrays.asList(vals));
    }
}

