/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.util.security;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.X509TrustManager;
import org.rhq.enterprise.server.util.security.BogusTrustManager;

public class UntrustedSSLSocketFactory
extends SSLSocketFactory {
    private SSLSocketFactory factory;

    public UntrustedSSLSocketFactory() {
        try {
            SSLContext sslcontext = SSLContext.getInstance("TLS");
            sslcontext.init(null, new X509TrustManager[]{new BogusTrustManager()}, null);
            this.factory = sslcontext.getSocketFactory();
        }
        catch (NoSuchAlgorithmException exc) {
            throw new IllegalStateException("Unable to get SSL context: " + exc.getMessage());
        }
        catch (KeyManagementException exc) {
            throw new IllegalStateException("Unable to initialize ctx with BogusTrustManager: " + exc.getMessage());
        }
    }

    public static SocketFactory getDefault() {
        return new UntrustedSSLSocketFactory();
    }

    @Override
    public Socket createSocket(Socket socket, String s, int i, boolean flag) throws IOException {
        return this.factory.createSocket(socket, s, i, flag);
    }

    @Override
    public Socket createSocket(InetAddress inaddr, int i, InetAddress inaddr1, int j) throws IOException {
        return this.factory.createSocket(inaddr, i, inaddr1, j);
    }

    @Override
    public Socket createSocket(InetAddress inaddr, int i) throws IOException {
        return this.factory.createSocket(inaddr, i);
    }

    @Override
    public Socket createSocket(String s, int i, InetAddress inaddr, int j) throws IOException {
        return this.factory.createSocket(s, i, inaddr, j);
    }

    @Override
    public Socket createSocket(String s, int i) throws IOException {
        return this.factory.createSocket(s, i);
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return this.factory.getSupportedCipherSuites();
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return this.factory.getSupportedCipherSuites();
    }
}

