/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.clientapi;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.remoting.invocation.NameBasedInvocation;
import org.rhq.bindings.client.AbstractRhqFacadeProxy;
import org.rhq.bindings.client.RhqFacade;
import org.rhq.bindings.client.RhqManagers;
import org.rhq.bindings.util.InterfaceSimplifier;
import org.rhq.core.server.ExternalizableStrategy;
import org.rhq.enterprise.clientapi.RemoteClient;

public class RemoteClientProxy
extends AbstractRhqFacadeProxy<RemoteClient> {
    private static final Log LOG = LogFactory.getLog(RemoteClientProxy.class);

    public RemoteClientProxy(RemoteClient client, RhqManagers manager) {
        super((RhqFacade)client, manager);
    }

    public Class<?> getRemoteInterface() {
        return this.getManager().remote();
    }

    public static <T> T getProcessor(RemoteClient remoteClient, RhqManagers manager) {
        try {
            RemoteClientProxy gpc = new RemoteClientProxy(remoteClient, manager);
            Class intf = InterfaceSimplifier.simplify((Class)manager.remote());
            return (T)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{intf}, (InvocationHandler)((Object)gpc));
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to get remote connection proxy", e);
        }
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        try {
            return super.invoke(proxy, method, args);
        }
        catch (Throwable t) {
            LOG.debug((Object)t);
            throw t;
        }
    }

    protected Object doInvoke(Object proxy, Method originalMethod, Class<?>[] argTypes, Object[] args) throws Throwable {
        ExternalizableStrategy.setStrategy((ExternalizableStrategy.Subsystem)ExternalizableStrategy.Subsystem.REFLECTIVE_SERIALIZATION);
        String methodName = this.getManager().beanName() + ":" + originalMethod.getName();
        String[] paramSig = this.createParamSignature(argTypes);
        NameBasedInvocation request = new NameBasedInvocation(methodName, args, paramSig);
        Object response = ((RemoteClient)this.getRhqFacade()).getRemotingClient().invoke((Object)request);
        if (response instanceof Throwable) {
            throw (Throwable)response;
        }
        return response;
    }

    private String[] createParamSignature(Class<?>[] types) {
        String[] paramSig = new String[types.length];
        for (int x = 0; x < types.length; ++x) {
            paramSig[x] = types[x].getName();
        }
        return paramSig;
    }
}

