/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.bindings.client;

import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.CtNewMethod;
import javassist.NotFoundException;
import javassist.bytecode.AttributeInfo;
import javassist.bytecode.ParameterAnnotationsAttribute;
import javassist.bytecode.annotation.Annotation;
import javassist.bytecode.annotation.MemberValue;
import javassist.bytecode.annotation.StringMemberValue;
import javassist.util.proxy.MethodHandler;
import javassist.util.proxy.ProxyFactory;
import javax.jws.WebParam;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.bindings.client.ResourceClientProxy;
import org.rhq.bindings.client.RhqFacade;
import org.rhq.bindings.util.ConfigurationClassBuilder;
import org.rhq.bindings.util.ResourceTypeFingerprint;
import org.rhq.core.domain.resource.ResourceCreationDataType;

public class ResourceClientFactory {
    private static final Log LOG = LogFactory.getLog(ResourceClientFactory.class);
    private static HashMap<Integer, CacheRecord> CUSTOM_CLASS_CACHE = new HashMap();
    private RhqFacade rhqFacade;
    private PrintWriter outputWriter;

    public ResourceClientFactory(RhqFacade remoteClient, PrintWriter outputWriter) {
        this.rhqFacade = remoteClient;
        this.outputWriter = outputWriter;
    }

    public RhqFacade getRemoteClient() {
        return this.rhqFacade;
    }

    public PrintWriter getOutputWriter() {
        return this.outputWriter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResourceClientProxy getResource(int resourceId) {
        ResourceClientProxy proxy = new ResourceClientProxy(this, resourceId);
        Class<?> customInterface = null;
        HashMap<Integer, CacheRecord> hashMap = CUSTOM_CLASS_CACHE;
        synchronized (hashMap) {
            Integer resourceTypeId = proxy.getResourceType().getId();
            CacheRecord record = CUSTOM_CLASS_CACHE.get(resourceTypeId);
            if (record == null || !record.fingerprint.equals(proxy.fingerprint)) {
                record = new CacheRecord();
                record.fingerprint = proxy.fingerprint;
                record.iface = this.defineCustomInterface(proxy);
                CUSTOM_CLASS_CACHE.put(resourceTypeId, record);
            }
            customInterface = record.iface;
        }
        if (customInterface != null) {
            ArrayList interfaces = new ArrayList();
            interfaces.add(customInterface);
            if (proxy.resourceConfigurationDefinition != null) {
                interfaces.add(this.getResourceConfigurableInterface());
            }
            if (proxy.pluginConfigurationDefinition != null) {
                interfaces.add(this.getPluginConfigurableInterface());
            }
            if (proxy.getResourceType().getCreationDataType() == ResourceCreationDataType.CONTENT) {
                interfaces.add(this.getContentBackedInterface());
            }
            interfaces.addAll(this.getAdditionalInterfaces(proxy));
            ProxyFactory proxyFactory = new ProxyFactory();
            proxyFactory.setInterfaces(interfaces.toArray(new Class[interfaces.size()]));
            proxyFactory.setSuperclass(ResourceClientProxy.class);
            ResourceClientProxy proxied = null;
            try {
                proxied = (ResourceClientProxy)proxyFactory.create(new Class[0], new Object[0], this.instantiateMethodHandler(proxy, interfaces, this.rhqFacade));
            }
            catch (InstantiationException e) {
                LOG.error((Object)"Could not instantiate a ResourceClientProxy, this is a bug.", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                LOG.error((Object)"Could not instantiate a ResourceClientProxy, this is a bug.", (Throwable)e);
            }
            catch (NoSuchMethodException e) {
                LOG.error((Object)"Could not instantiate a ResourceClientProxy, this is a bug.", (Throwable)e);
            }
            catch (InvocationTargetException e) {
                LOG.error((Object)"Could not instantiate a ResourceClientProxy, this is a bug.", (Throwable)e);
            }
            return proxied;
        }
        return proxy;
    }

    protected Class<?> getResourceConfigurableInterface() {
        return ResourceClientProxy.ResourceConfigurable.class;
    }

    protected Class<?> getPluginConfigurableInterface() {
        return ResourceClientProxy.PluginConfigurable.class;
    }

    protected Class<?> getContentBackedInterface() {
        return ResourceClientProxy.ContentBackedResource.class;
    }

    protected Set<Class<?>> getAdditionalInterfaces(ResourceClientProxy proxy) {
        return Collections.emptySet();
    }

    protected MethodHandler instantiateMethodHandler(ResourceClientProxy proxy, List<Class<?>> interfaces, RhqFacade remoteClient) {
        return new ResourceClientProxy.ClientProxyMethodHandler(proxy, remoteClient);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Class<?> defineCustomInterface(ResourceClientProxy proxy) {
        ClassPool pool = ClassPool.getDefault();
        CtClass customClass = pool.makeInterface(ResourceClientProxy.class.getName() + proxy.fingerprint);
        for (String key : proxy.allProperties.keySet()) {
            Object prop = proxy.allProperties.get(key);
            if (prop instanceof ResourceClientProxy.Measurement) {
                String name = ResourceClientProxy.getterName(key);
                try {
                    ResourceClientProxy.class.getMethod(name, new Class[0]);
                }
                catch (NoSuchMethodException nsme) {
                    CtMethod method = CtNewMethod.abstractMethod((CtClass)pool.get(ResourceClientProxy.Measurement.class.getName()), (String)ResourceClientProxy.getterName(key), (CtClass[])new CtClass[0], (CtClass[])new CtClass[0], (CtClass)customClass);
                    customClass.addMethod(method);
                }
                continue;
            }
            if (!(prop instanceof ResourceClientProxy.Operation)) continue;
            ResourceClientProxy.Operation o = (ResourceClientProxy.Operation)prop;
            LinkedHashMap<String, CtClass> types = ConfigurationClassBuilder.translateParameters(o.getDefinition().getParametersConfigurationDefinition());
            CtClass[] params = new CtClass[types.size()];
            int x = 0;
            for (String param : types.keySet()) {
                params[x++] = types.get(param);
            }
            CtMethod method = CtNewMethod.abstractMethod((CtClass)ConfigurationClassBuilder.translateConfiguration(o.getDefinition().getResultsConfigurationDefinition()), (String)ResourceClientProxy.simpleName(key), (CtClass[])params, (CtClass[])new CtClass[0], (CtClass)customClass);
            Annotation[][] newAnnotations = new Annotation[params.length][1];
            int i = 0;
            for (String paramName : types.keySet()) {
                newAnnotations[i] = new Annotation[1];
                newAnnotations[i][0] = new Annotation(WebParam.class.getName(), method.getMethodInfo().getConstPool());
                newAnnotations[i][0].addMemberValue("name", (MemberValue)new StringMemberValue(paramName, method.getMethodInfo().getConstPool()));
                ++i;
            }
            ParameterAnnotationsAttribute newAnnotationsAttribute = new ParameterAnnotationsAttribute(method.getMethodInfo().getConstPool(), "RuntimeVisibleParameterAnnotations");
            newAnnotationsAttribute.setAnnotations(newAnnotations);
            method.getMethodInfo().addAttribute((AttributeInfo)newAnnotationsAttribute);
            customClass.addMethod(method);
        }
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(ResourceClientProxy.class.getClassLoader());
            Class clazz = customClass.toClass();
            Thread.currentThread().setContextClassLoader(cl);
            return clazz;
        }
        catch (Throwable throwable) {
            try {
                Thread.currentThread().setContextClassLoader(cl);
                throw throwable;
            }
            catch (NotFoundException e) {
                LOG.error((Object)("Could not create custom interface for resource with id " + proxy.getId()), (Throwable)e);
            }
            catch (CannotCompileException e) {
                LOG.error((Object)("Could not create custom interface for resource with id " + proxy.getId()), (Throwable)e);
            }
            catch (Exception e) {
                LOG.error((Object)("Could not create custom interface for resource with id " + proxy.getId()), (Throwable)e);
            }
        }
        return null;
    }

    private static class CacheRecord {
        public ResourceTypeFingerprint fingerprint;
        public Class<?> iface;

        private CacheRecord() {
        }
    }
}

