/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.bindings.engine;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Set;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.rhq.bindings.engine.ScriptEngineInitializer;

public class JsEngineInitializer
implements ScriptEngineInitializer {
    private static final String WRAPPED_EXCEPTION_PREFIX = "Wrapped ";
    private ScriptEngineManager engineManager = new ScriptEngineManager();

    @Override
    public boolean implementsLanguage(String language) {
        return language != null && ("JavaScript".equals(language) || "ECMAScript".equals(language));
    }

    @Override
    public ScriptEngine instantiate(Set<String> packages) throws ScriptException {
        ScriptEngine eng = this.engineManager.getEngineByName("JavaScript");
        for (String pkg : packages) {
            eng.eval("importPackage(" + pkg + ")");
        }
        return eng;
    }

    @Override
    public Set<String> generateIndirectionMethods(String boundObjectName, Set<Method> methods) {
        if (methods.size() == 0) {
            return Collections.emptySet();
        }
        String methodName = methods.iterator().next().getName();
        StringBuilder functionBuilder = new StringBuilder("function ");
        functionBuilder.append(methodName).append("() { switch(arguments.length) { ");
        for (Method method : methods) {
            int argCnt = method.getParameterTypes().length;
            functionBuilder.append("case ").append(argCnt).append(": ");
            functionBuilder.append("return ").append(boundObjectName).append(".").append(methodName).append("(");
            for (int i = 0; i < argCnt; ++i) {
                if (i > 0) {
                    functionBuilder.append(", ");
                }
                functionBuilder.append("arguments[").append(i).append("]");
            }
            functionBuilder.append("); break; ");
        }
        functionBuilder.append(" default: throw \"Unsupported number of parameters.\"; } }");
        return Collections.singleton(functionBuilder.toString());
    }

    @Override
    public String extractUserFriendlyErrorMessage(ScriptException e) {
        String errorMessage = e.getMessage();
        int wrappedIdx = errorMessage.lastIndexOf(WRAPPED_EXCEPTION_PREFIX);
        if (wrappedIdx < 0) {
            return errorMessage;
        }
        int sourceInfoStartIdx = (errorMessage = errorMessage.substring(wrappedIdx + WRAPPED_EXCEPTION_PREFIX.length())).indexOf(" (<Unknown source>#");
        if (sourceInfoStartIdx >= 0) {
            errorMessage = errorMessage.substring(0, sourceInfoStartIdx);
        }
        return errorMessage;
    }
}

