/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.operation;

import javax.ejb.EJBException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.operation.OperationHistory;
import org.rhq.core.domain.operation.ResourceOperationHistory;
import org.rhq.core.domain.operation.bean.ResourceOperationSchedule;
import org.rhq.core.domain.resource.InventoryStatus;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.util.exception.ThrowableUtil;
import org.rhq.enterprise.server.agentclient.AgentClient;
import org.rhq.enterprise.server.auth.SubjectManagerLocal;
import org.rhq.enterprise.server.core.AgentManagerLocal;
import org.rhq.enterprise.server.operation.CancelJobException;
import org.rhq.enterprise.server.operation.OperationJob;
import org.rhq.enterprise.server.operation.OperationManagerLocal;
import org.rhq.enterprise.server.resource.ResourceManagerLocal;
import org.rhq.enterprise.server.resource.ResourceNotFoundException;
import org.rhq.enterprise.server.util.LookupUtil;

public class ResourceOperationJob
extends OperationJob {
    public static final String DATAMAP_INT_RESOURCE_ID = "resourceId";
    private static final Log log = LogFactory.getLog(ResourceOperationJob.class);
    private static final String RESOURCE_JOB_NAME_PREFIX = "rhq-resource-";

    public static String createUniqueJobName(Resource resource, String operationName) {
        return RESOURCE_JOB_NAME_PREFIX + resource.getId() + "-" + operationName.hashCode() + "-" + System.currentTimeMillis();
    }

    public static String createJobGroupName(Resource resource) {
        return RESOURCE_JOB_NAME_PREFIX + resource.getId();
    }

    public void execute(JobExecutionContext context) throws JobExecutionException {
        ResourceOperationSchedule schedule = null;
        try {
            JobDetail jobDetail = context.getJobDetail();
            OperationManagerLocal operationManager = LookupUtil.getOperationManager();
            this.updateOperationScheduleEntity(jobDetail, context.getNextFireTime(), operationManager);
            schedule = operationManager.getResourceOperationSchedule(this.getOverlord(), jobDetail);
            schedule.setSubject(this.getUserWithSession(schedule.getSubject()));
            operationManager.getResourceOperationSchedule(schedule.getSubject(), jobDetail);
            ResourceOperationHistory resourceHistory = this.createOperationHistory(jobDetail.getName(), jobDetail.getGroup(), schedule, null, operationManager);
            this.invokeOperationOnResource(schedule, resourceHistory, operationManager);
        }
        catch (Exception e) {
            if (e instanceof CancelJobException) {
                throw (CancelJobException)((Object)e);
            }
            String error = "Failed to execute scheduled operation [" + schedule + "]";
            log.error((Object)error, (Throwable)e);
            if (this.isResourceUncommitted(context.getJobDetail())) {
                int resourceId = this.getResourceId(context.getJobDetail());
                String msg = "The resource with id " + resourceId + " is not committed in inventory. It may have " + "been deleted from inventory. Canceling job.";
                log.warn((Object)msg);
                throw new CancelJobException(msg, e);
            }
            throw new JobExecutionException(error, (Throwable)e, false);
        }
    }

    private Subject getOverlord() {
        SubjectManagerLocal subjectMgr = LookupUtil.getSubjectManager();
        return subjectMgr.getOverlord();
    }

    private int getResourceId(JobDetail jobDetail) {
        JobDataMap jobDataMap = jobDetail.getJobDataMap();
        return jobDataMap.getIntFromString(DATAMAP_INT_RESOURCE_ID);
    }

    private boolean isResourceUncommitted(JobDetail jobDetail) {
        ResourceManagerLocal resourceMgr = LookupUtil.getResourceManager();
        int resourceId = this.getResourceId(jobDetail);
        try {
            Resource resource = resourceMgr.getResource(this.getOverlord(), resourceId);
            return this.isResourceUncommitted(resource);
        }
        catch (EJBException e) {
            if (e.getCausedByException() instanceof ResourceNotFoundException) {
                return true;
            }
            throw e;
        }
    }

    private boolean isResourceUncommitted(Resource resource) {
        return resource == null || resource.getInventoryStatus() != InventoryStatus.COMMITTED;
    }

    void invokeOperationOnResource(ResourceOperationSchedule schedule, ResourceOperationHistory resourceHistory, OperationManagerLocal operationManager) throws Exception {
        Subject s = this.getUserWithSession(schedule.getSubject());
        schedule.setSubject(s);
        resourceHistory.setStartedTime();
        resourceHistory = (ResourceOperationHistory)operationManager.updateOperationHistory(s, (OperationHistory)resourceHistory);
        try {
            Resource resource = schedule.getResource();
            if (this.isResourceUncommitted(resource)) {
                String msg = "The resource with id " + resource.getId() + " is not committed in inventory. It may " + "have been deleted from inventory. Canceling job.";
                log.warn((Object)msg);
                throw new CancelJobException(msg);
            }
            AgentManagerLocal agentManager = LookupUtil.getAgentManager();
            AgentClient agentClient = agentManager.getAgentClient(this.getOverlord(), resource.getId());
            agentClient.getOperationAgentService().invokeOperation(resourceHistory.getJobId().toString(), resource.getId(), schedule.getOperationName(), schedule.getParameters());
        }
        catch (Exception e) {
            resourceHistory.setErrorMessage(ThrowableUtil.getStackAsString((Throwable)e));
            operationManager.updateOperationHistory(s, (OperationHistory)resourceHistory);
            operationManager.checkForCompletedGroupOperation(resourceHistory.getId());
            throw e;
        }
    }
}

