/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.util.updater;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Properties;

public class DeploymentProperties
extends Properties {
    private static final long serialVersionUID = 1L;
    private static final String DEPLOYMENT_ID = "deployment.id";
    private static final String BUNDLE_NAME = "bundle.name";
    private static final String BUNDLE_VERSION = "bundle.version";
    private static final String BUNDLE_DESCRIPTION = "bundle.description";
    private static final String MANAGE_ROOT_DIR = "manage.root.dir";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DeploymentProperties loadFromFile(File file) throws Exception {
        DeploymentProperties props = new DeploymentProperties();
        FileInputStream is = new FileInputStream(file);
        try {
            props.load(is);
        }
        finally {
            is.close();
        }
        props.validate();
        return props;
    }

    public DeploymentProperties() {
    }

    public DeploymentProperties(int deploymentId, String bundleName, String bundleVersion, String description) {
        this.setDeploymentId(deploymentId);
        this.setBundleName(bundleName);
        this.setBundleVersion(bundleVersion);
        this.setDescription(description);
        try {
            this.validate();
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public boolean isValid() {
        try {
            this.validate();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveToFile(File file) throws Exception {
        this.validate();
        FileOutputStream os = new FileOutputStream(file);
        try {
            this.store(os, "This file is auto-generated - DO NOT MODIFY!!!");
        }
        finally {
            os.close();
        }
    }

    private void validate() throws Exception {
        try {
            this.getDeploymentId();
            this.getBundleName();
            this.getBundleVersion();
            this.getDescription();
        }
        catch (Exception e) {
            throw new Exception("Deployment properties are invalid: " + e.getMessage());
        }
    }

    public int getDeploymentId() {
        String str = this.getProperty(DEPLOYMENT_ID);
        if (str == null) {
            throw new IllegalStateException("There is no deployment ID");
        }
        try {
            int id = Integer.parseInt(str);
            return id;
        }
        catch (Exception e) {
            throw new IllegalStateException("Invalid deployment ID: " + str);
        }
    }

    public void setDeploymentId(int id) {
        this.setProperty(DEPLOYMENT_ID, Integer.toString(id));
    }

    public String getBundleName() {
        String str = this.getProperty(BUNDLE_NAME);
        if (str == null) {
            throw new IllegalStateException("There is no bundle name");
        }
        return str;
    }

    public void setBundleName(String name) {
        this.setProperty(BUNDLE_NAME, name);
    }

    public String getBundleVersion() {
        String str = this.getProperty(BUNDLE_VERSION);
        if (str == null) {
            throw new IllegalStateException("There is no bundle version");
        }
        return str;
    }

    public void setBundleVersion(String version) {
        this.setProperty(BUNDLE_VERSION, version);
    }

    public String getDescription() {
        String str = this.getProperty(BUNDLE_DESCRIPTION);
        return str;
    }

    public void setDescription(String description) {
        if (description == null) {
            this.remove(BUNDLE_DESCRIPTION);
        } else {
            this.setProperty(BUNDLE_DESCRIPTION, description);
        }
    }

    public boolean getManageRootDir() {
        String str = this.getProperty(MANAGE_ROOT_DIR);
        if (str == null) {
            return true;
        }
        return Boolean.parseBoolean(str);
    }

    public void setManageRootDir(boolean willManageRootDir) {
        this.setProperty(MANAGE_ROOT_DIR, Boolean.toString(willManageRootDir));
    }
}

