/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.client.commands;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Arrays;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.bindings.ScriptEngineFactory;
import org.rhq.bindings.StandardBindings;
import org.rhq.bindings.client.RhqFacade;
import org.rhq.bindings.client.RhqManagers;
import org.rhq.bindings.output.TabularWriter;
import org.rhq.bindings.util.PackageFinder;
import org.rhq.enterprise.client.ClientMain;
import org.rhq.enterprise.client.Controller;
import org.rhq.enterprise.client.commands.ClientCommand;
import org.rhq.enterprise.client.proxy.ConfigurationEditor;
import org.rhq.enterprise.client.proxy.EditableResourceClientFactory;
import org.rhq.enterprise.client.script.CLIScriptException;
import org.rhq.enterprise.client.script.CmdLineParser;
import org.rhq.enterprise.client.script.CommandLineParseException;
import org.rhq.enterprise.client.script.NamedScriptArg;
import org.rhq.enterprise.client.script.ScriptArg;
import org.rhq.enterprise.client.script.ScriptCmdLine;

public class ScriptCommand
implements ClientCommand {
    private ScriptEngine jsEngine;
    private StandardBindings bindings;
    private final Log log = LogFactory.getLog(ScriptCommand.class);
    private StringBuilder script = new StringBuilder();
    private boolean isMultilineScript = false;
    private boolean inMultilineScript = false;

    public ScriptEngine getScriptEngine() {
        if (this.jsEngine == null) {
            try {
                this.jsEngine = ScriptEngineFactory.getScriptEngine((String)"JavaScript", (PackageFinder)new PackageFinder(Arrays.asList(this.getLibDir())), null);
            }
            catch (ScriptException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return this.jsEngine;
    }

    @Override
    public String getPromptCommandString() {
        return "exec";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean execute(ClientMain client, String[] args) {
        int i;
        if (null == this.bindings) {
            this.initBindings(client);
        }
        if (this.isScriptFileCommandLine(args)) {
            try {
                CmdLineParser cmdLineParser = new CmdLineParser();
                ScriptCmdLine scriptCmdLine = cmdLineParser.parse(args);
                this.bindScriptArgs(scriptCmdLine);
                this.executeUtilScripts();
                FileReader reader = new FileReader(scriptCmdLine.getScriptFileName());
                try {
                    boolean bl = this.executeScriptFile(reader, client);
                    return bl;
                }
                finally {
                    try {
                        reader.close();
                    }
                    catch (IOException ignore) {}
                }
            }
            catch (FileNotFoundException e) {
                client.getPrintWriter().println(e.getMessage());
                if (!this.log.isDebugEnabled()) return true;
                this.log.debug((Object)("Unable to locate script file: " + e.getMessage()));
                return true;
            }
            catch (CommandLineParseException e) {
                if (!client.isInteractiveMode()) throw new CLIScriptException(e);
                client.getPrintWriter().println("parse error: " + e.getMessage());
                if (!this.log.isDebugEnabled()) return true;
                this.log.debug((Object)"A parse error occurred.", (Throwable)e);
                return true;
            }
        }
        this.isMultilineScript = "\\".equals(args[args.length - 1]);
        boolean bl = this.inMultilineScript = this.inMultilineScript || this.isMultilineScript;
        if (!this.isMultilineScript && !this.inMultilineScript) {
            this.script = new StringBuilder();
        }
        if (this.isMultilineScript) {
            args = Arrays.copyOfRange(args, 0, args.length - 1);
        }
        int n = i = "exec".equals(args[0]) ? 1 : 0;
        while (i < args.length) {
            this.script.append(args[i]);
            this.script.append(" ");
            ++i;
        }
        if (this.isMultilineScript) {
            return true;
        }
        try {
            Object result = this.getScriptEngine().eval(this.script.toString());
            this.inMultilineScript = false;
            this.script = new StringBuilder();
            if (result != null) {
                TabularWriter writer = new TabularWriter(client.getPrintWriter());
                if (client.isInteractiveMode()) {
                    writer.setWidth(client.getConsoleWidth());
                }
                writer.print(result);
            }
        }
        catch (ScriptException e) {
            String message = e.getCause() != null ? e.getCause().getMessage() : e.getMessage();
            message = message.replace("sun.org.mozilla.javascript.internal.EcmaError: ", "");
            message = message.replace("(<Unknown source>#1) in <Unknown source> at line number 1", "");
            client.getPrintWriter().println(message);
            client.getPrintWriter().println(this.script);
            for (int i2 = 0; i2 < e.getColumnNumber(); ++i2) {
                client.getPrintWriter().print(" ");
            }
            client.getPrintWriter().println("^");
            this.script = new StringBuilder();
            this.inMultilineScript = false;
        }
        client.getPrintWriter().println();
        return true;
    }

    private void initBindings(ClientMain client) {
        this.bindings = new StandardBindings(client.getPrintWriter(), (RhqFacade)client.getRemoteClient());
        ((TabularWriter)this.bindings.getPretty().getValue()).setWidth(client.getConsoleWidth());
        if (client.getRemoteClient() != null) {
            this.bindings.getProxyFactory().setValue(new EditableResourceClientFactory(client));
        } else {
            this.bindings.getProxyFactory().setValue(null);
        }
        this.bindings.put((Object)"configurationEditor", (Object)new ConfigurationEditor(client));
        this.bindings.put((Object)"rhq", (Object)new Controller(client));
        ScriptEngine engine = this.getScriptEngine();
        ScriptEngineFactory.injectStandardBindings((ScriptEngine)engine, (StandardBindings)this.bindings, (boolean)false);
        ScriptEngineFactory.bindIndirectionMethods((ScriptEngine)engine, (String)"configurationEditor");
        ScriptEngineFactory.bindIndirectionMethods((ScriptEngine)engine, (String)"rhq");
    }

    public void initClient(ClientMain client) {
        if (null == this.bindings) {
            this.initBindings(client);
        } else {
            ScriptEngine engine = this.getScriptEngine();
            ScriptEngineFactory.removeBindings((ScriptEngine)engine, this.bindings.getManagers().keySet());
            this.bindings.setFacade(client.getPrintWriter(), (RhqFacade)client.getRemoteClient());
            ScriptEngineFactory.injectStandardBindings((ScriptEngine)engine, (StandardBindings)this.bindings, (boolean)false);
        }
    }

    private void executeUtilScripts() {
        InputStream stream = this.getClass().getResourceAsStream("test_utils.js");
        InputStreamReader reader = new InputStreamReader(stream);
        try {
            this.getScriptEngine().eval(reader);
        }
        catch (ScriptException e) {
            this.log.warn((Object)"An error occurred while executing test_utils.js", (Throwable)e);
        }
    }

    private boolean isScriptFileCommandLine(String[] args) {
        if (args == null || args.length < 3) {
            return false;
        }
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].equals("-f")) continue;
            return true;
        }
        return false;
    }

    private void bindScriptArgs(ScriptCmdLine cmdLine) {
        this.bindArgsArray(cmdLine);
        if (cmdLine.getArgType() == ScriptCmdLine.ArgType.NAMED) {
            this.bindNamedArgs(cmdLine);
        }
        this.getScriptEngine().put("script", new File(cmdLine.getScriptFileName()).getName());
    }

    private void bindArgsArray(ScriptCmdLine cmdLine) {
        String[] args = new String[cmdLine.getArgs().size()];
        int i = 0;
        for (ScriptArg arg : cmdLine.getArgs()) {
            args[i++] = arg.getValue();
        }
        this.getScriptEngine().put("args", args);
    }

    private void bindNamedArgs(ScriptCmdLine cmdLine) {
        for (ScriptArg arg : cmdLine.getArgs()) {
            NamedScriptArg namedArg = (NamedScriptArg)arg;
            this.getScriptEngine().put(namedArg.getName(), namedArg.getValue());
        }
    }

    private boolean executeScriptFile(Reader reader, ClientMain client) {
        try {
            Object result = this.getScriptEngine().eval(reader);
            if (result != null && client.isInteractiveMode()) {
                new TabularWriter(client.getPrintWriter()).print(result);
            }
        }
        catch (ScriptException e) {
            if (client.isInteractiveMode()) {
                client.getPrintWriter().println(e.getMessage());
                client.getPrintWriter().println("^");
            }
            throw new CLIScriptException(e);
        }
        return true;
    }

    @Override
    public String getSyntax() {
        return this.getPromptCommandString() + " <statement> | [-s<indexed|named>] -f <file> [args]";
    }

    @Override
    public String getHelp() {
        return "Execute a statement or a script";
    }

    @Override
    public String getDetailedHelp() {
        return "Execute a statement or a script. The following service managers are available: " + Arrays.toString(RhqManagers.values());
    }

    public ScriptContext getContext() {
        return this.getScriptEngine().getContext();
    }

    private File getLibDir() {
        String cwd = System.getProperty("user.dir");
        return new File(cwd, "lib");
    }
}

