/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.bindings.util;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import javax.script.ScriptEngine;
import org.rhq.bindings.util.NoTopLevelIndirection;
import org.rhq.bindings.util.ScriptAssertionException;

public class ScriptAssert {
    private ScriptEngine scriptEngine;

    private static String format(Object actual, Object expected, String message) {
        String formatted = "";
        if (null != message) {
            formatted = message + " ";
        }
        return formatted + "expected:<" + expected + "> but was:<" + actual + ">";
    }

    private void failNotEquals(Object actual, Object expected, String message) {
        this.fail(ScriptAssert.format(actual, expected, message));
    }

    private void failAssertNoEqual(Object[] actual, Object[] expected, String message, String defaultMessage) {
        if (message != null) {
            this.fail(message);
        } else {
            this.fail(defaultMessage);
        }
    }

    public ScriptAssert() {
    }

    public ScriptAssert(ScriptEngine scriptEngine) {
        this.scriptEngine = scriptEngine;
    }

    @NoTopLevelIndirection
    public void init(ScriptEngine engine) {
        this.scriptEngine = engine;
    }

    public void assertTrue(boolean condition, String msg) {
        if (!condition) {
            this.failNotEquals(condition, Boolean.TRUE, msg);
        }
    }

    public void assertTrue(boolean condition) {
        this.assertTrue(condition, null);
    }

    public void assertFalse(boolean condition, String msg) {
        if (condition) {
            this.failNotEquals(condition, Boolean.FALSE, msg);
        }
    }

    public void assertFalse(boolean condition) {
        this.assertFalse(condition, null);
    }

    public void fail(String msg, Throwable throwable) {
        throw new ScriptAssertionException(msg, throwable);
    }

    public void fail(String msg) {
        throw new ScriptAssertionException(msg);
    }

    public void fail() {
        throw new ScriptAssertionException();
    }

    public void assertEquals(Object actual, Object expected, String msg) {
        if (expected == null && actual == null) {
            return;
        }
        if (expected != null) {
            if (expected.getClass().isArray()) {
                this.assertArrayEquals(actual, expected, msg);
                return;
            }
            if (expected.equals(actual)) {
                return;
            }
        }
        this.failNotEquals(actual, expected, msg);
    }

    private void assertArrayEquals(Object actual, Object expected, String message) {
        if (actual.getClass().isArray()) {
            int expectedLength = Array.getLength(expected);
            if (expectedLength == Array.getLength(actual)) {
                for (int i = 0; i < expectedLength; ++i) {
                    Object _actual = Array.get(actual, i);
                    Object _expected = Array.get(expected, i);
                    try {
                        this.assertEquals(_actual, _expected);
                        continue;
                    }
                    catch (AssertionError ae) {
                        this.failNotEquals(actual, expected, message == null ? "" : message + " (values as index " + i + " are not the same)");
                    }
                }
                return;
            }
            this.failNotEquals(Array.getLength(actual), expectedLength, message == null ? "" : message + " (Array lengths are not the same)");
        }
        this.failNotEquals(actual, expected, message);
    }

    public void assertEquals(Object actual, Object expected) {
        this.assertEquals(actual, expected, null);
    }

    public void assertNotNull(Object object) {
        this.assertNotNull(object, null);
    }

    public void assertNotNull(Object object, String msg) {
        if (object == null) {
            String message = "";
            if (msg != null) {
                message = message + msg + " ";
            }
            message = "expected the object to not be null";
            this.fail(message);
        }
    }

    public void assertNull(Object object) {
        this.assertNull(object, null);
    }

    public void assertNull(Object object, String msg) {
        if (object != null) {
            this.failNotEquals(object, null, msg);
        }
    }

    public void assertSame(Object actual, Object expected, String msg) {
        if (actual != expected) {
            this.failNotEquals(actual, expected, msg);
        }
    }

    public void assertSame(Object actual, Object expected) {
        this.assertSame(actual, expected, null);
    }

    public void assertNotSame(Object actual, Object expected, String msg) {
        if (actual == expected) {
            String formatted = "";
            if (msg != null) {
                formatted = msg + " ";
            }
            this.fail(formatted + "expected not same with:<" + expected + "> but was same:<" + actual + ">");
        }
    }

    public void assertNotSame(Object actual, Object expected) {
        this.assertNotSame(actual, expected, null);
    }

    public void assertEquals(Collection<?> actual, Collection<?> expected) {
        this.assertEquals(actual, expected, null);
    }

    public void assertEquals(Collection<?> actual, Collection<?> expected, String msg) {
        if (actual == expected) {
            return;
        }
        if (actual == null || expected == null) {
            if (msg != null) {
                this.fail(msg);
            } else {
                this.fail("Collections not equal: expected: " + expected + " and actual: " + actual);
            }
        }
        this.assertEquals(actual.size(), expected.size(), msg + ": lists don't have the same size");
        Iterator<?> actIt = actual.iterator();
        Iterator<?> expIt = expected.iterator();
        int i = -1;
        while (actIt.hasNext() && expIt.hasNext()) {
            Object e = expIt.next();
            Object a = actIt.next();
            String explanation = "Lists differ at element [" + ++i + "]: " + e + " != " + a;
            String errorMessage = msg == null ? explanation : msg + ": " + explanation;
            this.assertEquals(a, e, errorMessage);
        }
    }

    public void assertEquals(Object[] actual, Object[] expected, String msg) {
        if (actual == expected) {
            return;
        }
        if (actual == null && expected != null || actual != null && expected == null) {
            if (msg != null) {
                this.fail(msg);
            } else {
                this.fail("Arrays not equal: " + Arrays.toString(expected) + " and " + Arrays.toString(actual));
            }
        }
        this.assertEquals(Arrays.asList(actual), Arrays.asList(expected), msg);
    }

    public void assertEqualsNoOrder(Object[] actual, Object[] expected, String msg) {
        if (actual == expected) {
            return;
        }
        if (actual == null && expected != null || actual != null && expected == null) {
            this.failAssertNoEqual(actual, expected, "Arrays not equal: " + Arrays.toString(expected) + " and " + Arrays.toString(actual), msg);
        }
        if (actual.length != expected.length) {
            this.failAssertNoEqual(actual, expected, "Arrays do not have the same size:" + actual.length + " != " + expected.length, msg);
        }
        ArrayList<Object> actualCollection = new ArrayList<Object>();
        for (Object a : actual) {
            actualCollection.add(a);
        }
        for (Object o : expected) {
            actualCollection.remove(o);
        }
        if (actualCollection.size() != 0) {
            this.failAssertNoEqual(actual, expected, "Arrays not equal: " + Arrays.toString(expected) + " and " + Arrays.toString(actual), msg);
        }
    }

    public void assertEquals(Object[] actual, Object[] expected) {
        this.assertEquals(actual, expected, (String)null);
    }

    public void assertEqualsNoOrder(Object[] actual, Object[] expected) {
        this.assertEqualsNoOrder(actual, expected, null);
    }

    public void assertExists(String identifier) {
        Object value = this.scriptEngine.get(identifier);
        this.assertNotNull(value, identifier + " is not defined");
    }

    @Deprecated
    public void assertNumberEqualsJS(double actual, double expected, String msg) {
        this.assertEquals(actual, expected, msg);
    }
}

