/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.client.commands;

import org.rhq.enterprise.client.ClientMain;
import org.rhq.enterprise.client.commands.ClientCommand;
import org.rhq.enterprise.clientapi.RemoteClient;

public class LogoutCommand
implements ClientCommand {
    @Override
    public String getPromptCommandString() {
        return "logout";
    }

    @Override
    public boolean execute(ClientMain client, String[] args) {
        this.execute(client);
        client.getPrintWriter().println("Logout successful");
        return true;
    }

    public void execute(ClientMain client) {
        client.setTransport(null);
        client.setHost(null);
        client.setPort(0);
        RemoteClient remoteClient = client.getRemoteClient();
        if (null != remoteClient) {
            remoteClient.logout();
        }
        client.setRemoteClient(null);
        client.setSubject(null);
        client.setUser(null);
        client.setPass(null);
    }

    @Override
    public String getSyntax() {
        return this.getPromptCommandString();
    }

    @Override
    public String getHelp() {
        return "Logout and disconnect from the server but do not exit the CLI";
    }

    @Override
    public String getDetailedHelp() {
        return this.getHelp();
    }
}

