/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.naming.AuthenticationException;
import javax.naming.NamingException;
import javax.naming.ldap.InitialLdapContext;
import javax.security.auth.login.AppConfigurationEntry;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.common.composite.SystemSetting;
import org.rhq.enterprise.server.RHQConstants;
import org.rhq.enterprise.server.core.CustomJaasDeploymentServiceMBean;
import org.rhq.enterprise.server.core.jaas.JDBCLoginModule;
import org.rhq.enterprise.server.core.jaas.JDBCPrincipalCheckLoginModule;
import org.rhq.enterprise.server.core.jaas.LdapLoginModule;
import org.rhq.enterprise.server.util.LookupUtil;
import org.rhq.enterprise.server.util.security.UntrustedSSLSocketFactory;

public class CustomJaasDeploymentService
implements CustomJaasDeploymentServiceMBean,
MBeanRegistration {
    private static final String AUTH_METHOD = "addAppConfig";
    private static final String AUTH_OBJECTNAME = "jboss.security:service=XMLLoginConfig";
    private Log log = LogFactory.getLog((String)CustomJaasDeploymentService.class.getName());
    private MBeanServer mbeanServer = null;

    public void installJaasModules() {
        try {
            this.log.info((Object)"Installing RHQ Server's JAAS login modules");
            Properties systemConfig = LookupUtil.getSystemManager().getSystemConfiguration(LookupUtil.getSubjectManager().getOverlord());
            this.registerJaasModules(systemConfig);
        }
        catch (Exception e) {
            this.log.fatal((Object)"Error deploying JAAS login modules", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        this.mbeanServer = server;
        return name;
    }

    @Override
    public void postRegister(Boolean registrationDone) {
    }

    @Override
    public void preDeregister() {
    }

    @Override
    public void postDeregister() {
    }

    private void registerJaasModules(Properties systemConfig) throws Exception {
        ArrayList<AppConfigurationEntry> configEntries = new ArrayList<AppConfigurationEntry>();
        try {
            boolean isLdapAuthenticationEnabled;
            Map<String, String> configOptions = this.getJdbcOptions(systemConfig);
            AppConfigurationEntry ace = new AppConfigurationEntry(JDBCLoginModule.class.getName(), AppConfigurationEntry.LoginModuleControlFlag.SUFFICIENT, configOptions);
            this.log.info((Object)"Enabling RHQ JDBC JAAS Provider...");
            configEntries.add(ace);
            String value = systemConfig.getProperty(SystemSetting.LDAP_BASED_JAAS_PROVIDER.getInternalName());
            boolean bl = isLdapAuthenticationEnabled = value != null ? "LDAP".equals(value) : false;
            if (isLdapAuthenticationEnabled) {
                configOptions = this.getJdbcOptions(systemConfig);
                ace = new AppConfigurationEntry(JDBCPrincipalCheckLoginModule.class.getName(), AppConfigurationEntry.LoginModuleControlFlag.REQUISITE, configOptions);
                this.log.info((Object)"Enabling RHQ JDBC-2 Principal Check JAAS Provider...");
                configEntries.add(ace);
                configOptions = this.getLdapOptions(systemConfig);
                try {
                    this.validateLdapOptions(configOptions);
                }
                catch (NamingException e) {
                    String descriptiveMessage = null;
                    descriptiveMessage = e instanceof AuthenticationException ? "The LDAP integration cannot function because the LDAP Bind credentials for RHQ integration are incorrect. Contact the Administrator:" + e : "Problems encountered when communicating with LDAP server. Contact the Administrator:" + e;
                    this.log.error((Object)descriptiveMessage, (Throwable)e);
                }
                ace = new AppConfigurationEntry(LdapLoginModule.class.getName(), AppConfigurationEntry.LoginModuleControlFlag.REQUISITE, configOptions);
                this.log.info((Object)"Enabling RHQ JDBC-2 LDAP JAAS Provider...");
                configEntries.add(ace);
            }
            AppConfigurationEntry[] config = configEntries.toArray(new AppConfigurationEntry[0]);
            ObjectName objName = new ObjectName(AUTH_OBJECTNAME);
            Object obj = this.mbeanServer.invoke(objName, AUTH_METHOD, new Object[]{"JON", config}, new String[]{"java.lang.String", config.getClass().getName()});
        }
        catch (Exception e) {
            throw new Exception("Error registering RHQ JAAS modules", e);
        }
    }

    private Map<String, String> getJdbcOptions(Properties conf) {
        HashMap<String, String> configOptions = new HashMap<String, String>();
        configOptions.put("hashAlgorithm", "MD5");
        configOptions.put("hashEncoding", "base64");
        return configOptions;
    }

    private Map<String, String> getLdapOptions(Properties conf) {
        HashMap<String, String> configOptions = new HashMap<String, String>();
        configOptions.put("java.naming.factory.initial", conf.getProperty(RHQConstants.LDAPFactory));
        configOptions.put("java.naming.provider.url", conf.getProperty(RHQConstants.LDAPUrl));
        String value = conf.getProperty(SystemSetting.USE_SSL_FOR_LDAP.getInternalName());
        boolean ldapSsl = "ssl".equalsIgnoreCase(value);
        configOptions.put("java.naming.security.protocol", ldapSsl ? "ssl" : null);
        configOptions.put("LoginProperty", conf.getProperty(RHQConstants.LDAPLoginProperty));
        configOptions.put("Filter", conf.getProperty(RHQConstants.LDAPFilter));
        configOptions.put("GroupFilter", conf.getProperty(RHQConstants.LDAPGroupFilter));
        configOptions.put("GroupMemberFilter", conf.getProperty(RHQConstants.LDAPGroupMember));
        configOptions.put("BaseDN", conf.getProperty(RHQConstants.LDAPBaseDN));
        configOptions.put("BindDN", conf.getProperty(RHQConstants.LDAPBindDN));
        configOptions.put("BindPW", conf.getProperty(RHQConstants.LDAPBindPW));
        return configOptions;
    }

    private void validateLdapOptions(Map<String, String> options) throws NamingException {
        Properties env = new Properties();
        String factory = options.get("java.naming.factory.initial");
        if (factory == null) {
            throw new NamingException("No initial context factory");
        }
        String url = options.get("java.naming.provider.url");
        if (url == null) {
            throw new NamingException("Naming provider url not set");
        }
        String protocol = options.get("java.naming.security.protocol");
        if ("ssl".equals(protocol)) {
            String ldapSocketFactory = env.getProperty("java.naming.ldap.factory.socket");
            if (ldapSocketFactory == null) {
                env.put("java.naming.ldap.factory.socket", UntrustedSSLSocketFactory.class.getName());
            }
            env.put("java.naming.security.protocol", "ssl");
        }
        env.setProperty("java.naming.factory.initial", factory);
        env.setProperty("java.naming.provider.url", url);
        String bindDN = options.get("BindDN");
        String bindPW = options.get("BindPW");
        if (bindDN != null && bindDN.length() != 0 && bindPW != null && bindPW.length() != 0) {
            env.setProperty("java.naming.security.principal", bindDN);
            env.setProperty("java.naming.security.credentials", bindPW);
            env.setProperty("java.naming.security.authentication", "simple");
        }
        this.log.debug((Object)"Validating LDAP properties. Initializing context...");
        new InitialLdapContext(env, null).close();
    }
}

