/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.measurement;

import java.io.Serializable;
import java.util.Date;
import org.rhq.core.domain.measurement.AvailabilityType;

public class AvailabilityPoint
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final AvailabilityType availabilityType;
    private final long timestamp;
    private final int value;

    public AvailabilityPoint(AvailabilityType availabilityType, long timestamp) {
        this.availabilityType = null == availabilityType ? AvailabilityType.UNKNOWN : availabilityType;
        this.timestamp = timestamp;
        this.value = this.availabilityType.ordinal();
    }

    public boolean isKnown() {
        return AvailabilityType.UNKNOWN != this.availabilityType;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public AvailabilityType getAvailabilityType() {
        return this.availabilityType;
    }

    public int getValue() {
        return this.value;
    }

    public String toString() {
        StringBuilder str = new StringBuilder("AvailabilityPoint ");
        str.append("value=[" + this.availabilityType.name());
        str.append("], timestamp=[" + this.timestamp);
        str.append("(" + new Date(this.timestamp) + ")]");
        return str.toString();
    }
}

