/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.rest;

import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiParam;
import java.util.List;
import javax.ejb.Local;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.jboss.resteasy.annotations.GZIP;
import org.jboss.resteasy.annotations.cache.Cache;
import org.rhq.enterprise.server.rest.domain.AlertDefinitionRest;
import org.rhq.enterprise.server.rest.domain.AlertRest;

@Produces(value={"application/json", "application/xml", "text/plain"})
@Local
@Path(value="/alert")
@Api(value="Deal with Alerts", description="This api deals with alerts that have fired. It does not offer to create/update AlertDefinitions (yet)")
public interface AlertHandlerLocal {
    @GZIP
    @GET
    @Path(value="/")
    @ApiOperation(value="List all alerts", multiValueResponse=true, responseClass="List<AlertRest>")
    public Response listAlerts(@ApiParam(value="Page number", defaultValue="0") @QueryParam(value="page") int var1, @ApiParam(value="Limit to priority", allowableValues="High, Medium, Low, All") @DefaultValue(value="All") @QueryParam(value="prio") String var2, @ApiParam(value="Should full resources and definitions be sent") @QueryParam(value="slim") @DefaultValue(value="false") boolean var3, @ApiParam(value="If non-null only send alerts that have fired after this time, time is millisecond since epoch") @QueryParam(value="since") Long var4, @ApiParam(value="Id of a resource to limit search for") @QueryParam(value="resourceId") Integer var5, @Context Request var6, @Context UriInfo var7, @Context HttpHeaders var8);

    @GET
    @Path(value="count")
    @ApiOperation(value="Return a count of alerts in the system depending on criteria")
    public int countAlerts(@ApiParam(value="If non-null only send alerts that have fired after this time, time is millisecond since epoch") @QueryParam(value="since") Long var1);

    @GET
    @Cache(maxAge=60)
    @Path(value="/{id}")
    @ApiOperation(value="Get one alert with the passed id", responseClass="AlertRest")
    public Response getAlert(@ApiParam(value="Id of the alert to retrieve") @PathParam(value="id") int var1, @ApiParam(value="Should full resources and definitions be sent") @QueryParam(value="slim") @DefaultValue(value="false") boolean var2, @Context UriInfo var3, @Context Request var4, @Context HttpHeaders var5);

    @GET
    @Path(value="/{id}/conditions")
    @Cache(maxAge=300)
    @ApiOperation(value="Return the notification logs for the given alert")
    public Response getConditionLogs(@ApiParam(value="Id of the alert to retrieve") @PathParam(value="id") int var1, @Context Request var2, @Context UriInfo var3, @Context HttpHeaders var4);

    @GET
    @Path(value="/{id}/notifications")
    @Cache(maxAge=60)
    @ApiOperation(value="Return the notification logs for the given alert")
    public Response getNotificationLogs(@ApiParam(value="Id of the alert to retrieve") @PathParam(value="id") int var1, @Context Request var2, @Context UriInfo var3, @Context HttpHeaders var4);

    @PUT
    @Path(value="/{id}")
    @ApiOperation(value="Mark the alert as acknowledged (by the caller)", notes="Returns a slim version of the alert")
    public AlertRest ackAlert(@ApiParam(value="Id of the alert to acknowledge") @PathParam(value="id") int var1, @Context UriInfo var2);

    @DELETE
    @Path(value="/{id}")
    @ApiOperation(value="Remove the alert from the lit of alerts")
    public void purgeAlert(@ApiParam(value="Id of the alert to remove") @PathParam(value="id") int var1);

    @GET
    @Cache(maxAge=300)
    @Path(value="/{id}/definition")
    @ApiOperation(value="Get the alert definition (basics) for the alert")
    public AlertDefinitionRest getDefinitionForAlert(@ApiParam(value="Id of the alert to show the definition") @PathParam(value="id") int var1);

    @GZIP
    @GET
    @Path(value="/definition")
    @ApiOperation(value="List all Alert Definition")
    public List<AlertDefinitionRest> listAlertDefinitions(@ApiParam(value="Page number", defaultValue="0") @QueryParam(value="page") int var1, @ApiParam(value="Limit to status, UNUSED AT THE MOMENT ") @QueryParam(value="status") String var2);

    @GET
    @Path(value="/definition/{id}")
    @ApiOperation(value="Get one AlertDefinition by id", responseClass="AlertDefinitionRest")
    public Response getAlertDefinition(@ApiParam(value="Id of the alert definition to retrieve") @PathParam(value="id") int var1, @Context Request var2);

    @PUT
    @Path(value="/definition/{id}")
    @ApiOperation(value="Update the alert definition (priority, enablement)", notes="Priority must be HIGH,LOW,MEDIUM")
    public Response updateDefinition(@ApiParam(value="Id of the alert definition to update") @PathParam(value="id") int var1, AlertDefinitionRest var2, @Context Request var3);
}

