/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.rest;

import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.enterprise.server.authz.PermissionException;
import org.rhq.enterprise.server.resource.ResourceNotFoundException;
import org.rhq.enterprise.server.rest.ParameterMissingException;
import org.rhq.enterprise.server.rest.StuffNotFoundException;
import org.rhq.enterprise.server.rest.domain.RHQErrorWrapper;

@Provider
public class CustomExceptionMapper
implements ExceptionMapper<Exception> {
    @Context
    HttpHeaders httpHeaders;
    Log log = LogFactory.getLog((String)this.getClass().getName());

    public Response toResponse(Exception e) {
        Response.ResponseBuilder builder;
        Throwable cause = e.getCause();
        if (cause != null) {
            Response.Status status = cause instanceof StuffNotFoundException ? Response.Status.NOT_FOUND : (cause instanceof ResourceNotFoundException ? Response.Status.NOT_FOUND : (cause instanceof ParameterMissingException ? Response.Status.NOT_ACCEPTABLE : (cause instanceof PermissionException ? Response.Status.FORBIDDEN : Response.Status.SERVICE_UNAVAILABLE)));
            builder = Response.status((Response.Status)status);
            String message = cause.getMessage();
            this.wrapMessage(builder, message);
        } else {
            builder = e instanceof PermissionException ? Response.status((Response.Status)Response.Status.FORBIDDEN) : Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
            if (e.getMessage() != null) {
                this.wrapMessage(builder, e.getMessage());
            }
        }
        return builder.build();
    }

    private void wrapMessage(Response.ResponseBuilder builder, String message) {
        MediaType mediaType;
        try {
            mediaType = (MediaType)this.httpHeaders.getAcceptableMediaTypes().get(0);
        }
        catch (Exception e) {
            this.log.debug((Object)e.getMessage());
            mediaType = MediaType.TEXT_PLAIN_TYPE;
        }
        if (mediaType.equals((Object)MediaType.TEXT_PLAIN_TYPE)) {
            builder.entity((Object)message);
        } else if (mediaType.equals((Object)MediaType.TEXT_HTML_TYPE)) {
            builder.entity((Object)("<html><body><h1>Error</h1><h2>" + message + "</h2></body></html>"));
        } else {
            RHQErrorWrapper error = new RHQErrorWrapper(message);
            builder.entity((Object)error);
        }
        builder.type(mediaType);
    }
}

