/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.rest;

import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiParam;
import java.util.List;
import javax.ejb.Local;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.annotations.GZIP;
import org.rhq.enterprise.server.rest.domain.EventRest;
import org.rhq.enterprise.server.rest.domain.EventSourceRest;

@Local
@Path(value="/event")
@Api(value="Api that deals with Events (e.g snmp traps, logfile lines)")
@Produces(value={"application/json", "application/xml", "text/html"})
public interface EventHandlerLocal {
    @GET
    @Path(value="/{id}/sources")
    @ApiOperation(value="List the defined event sources for the resource", responseClass="EventSourceRest", multiValueResponse=true)
    public Response listEventSourcesForResource(@ApiParam(value="id of the resource") @PathParam(value="id") int var1, @Context Request var2, @Context HttpHeaders var3);

    @POST
    @Path(value="/{id}/sources")
    @ApiOperation(value="Add a new event source for a resource. This can e.g. be a different logfile. The source.name must match an existing definition fo this resource. If an event source for the definition name and resource with the same location already exists, no new source is created. NOTE: An Event source added this way will not sow up in the connection properties.")
    public EventSourceRest addEventSource(@ApiParam(value="id of the resource") @PathParam(value="id") int var1, EventSourceRest var2);

    @DELETE
    @Path(value="/source/{id}")
    @ApiOperation(value="Delete the event source with the passed id")
    public Response deleteEventSource(@ApiParam(value="Id of the source to delete") @PathParam(value="id") int var1);

    @GET
    @Path(value="/source/{id}")
    @ApiOperation(value="Retrieve the event source with the passed id", responseClass="EventSourceRest")
    public EventSourceRest getEventSource(@ApiParam(value="Id of the source to retrieve") @PathParam(value="id") int var1);

    @POST
    @Path(value="/source/{id}/events")
    @ApiOperation(value="Submit multiple events for one given event source; the event source in the passed Events is ignored.")
    public Response addEventsToSource(@ApiParam(value="Id of the source to add data to") @PathParam(value="id") int var1, List<EventRest> var2);

    @GET
    @GZIP
    @Path(value="/source/{id}/events")
    @ApiOperation(value="List the events for the event source with the passed id. If no time range is given, the last 200 entries will be displayed", responseClass="EventRest", multiValueResponse=true)
    public Response getEventsForSource(@PathParam(value="id") int var1, @QueryParam(value="startTime") long var2, @QueryParam(value="endTime") long var4, @ApiParam(value="Select the severity to display. Default is to show all", allowableValues="DEBUG, INFO, WARN, ERROR, FATAL") @QueryParam(value="severity") String var6, @Context Request var7, @Context HttpHeaders var8);

    @GET
    @GZIP
    @Path(value="/{id}/events")
    @ApiOperation(value="List the events for the resource with the passed id. If no time range is given, the last 200 entries will be displayed", responseClass="EventRest", multiValueResponse=true)
    public Response getEventsForResource(@PathParam(value="id") int var1, @QueryParam(value="startTime") long var2, @QueryParam(value="endTime") long var4, @QueryParam(value="severity") String var6, @Context Request var7, @Context HttpHeaders var8);
}

