/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.rest;

import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiError;
import com.wordnik.swagger.annotations.ApiErrors;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiParam;
import javax.ejb.Local;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.jboss.resteasy.annotations.GZIP;
import org.jboss.resteasy.annotations.cache.Cache;
import org.rhq.enterprise.server.rest.domain.GroupDefinitionRest;
import org.rhq.enterprise.server.rest.domain.GroupRest;

@Local
@Path(value="/group")
@Api(value="Deal with groups and DynaGroups", description="Api that deals with resource groups and group definitions")
@Produces(value={"application/json", "application/xml", "text/html", "application/yaml"})
public interface GroupHandlerLocal {
    @GZIP
    @GET
    @Path(value="/")
    @ApiOperation(value="List all groups", multiValueResponse=true)
    public Response getGroups(@Context Request var1, @Context HttpHeaders var2, @Context UriInfo var3);

    @Cache(isPrivate=true, maxAge=60)
    @GET
    @Path(value="{id}")
    @ApiOperation(value="Get the group with the passed id")
    public Response getGroup(@ApiParam(value="Id of the group") @PathParam(value="id") int var1, @Context Request var2, @Context HttpHeaders var3, @Context UriInfo var4);

    @GET
    @GZIP
    @Path(value="{id}/metricDefinitions")
    @ApiOperation(value="Get the metric definitions for the compatible group with the passed id")
    public Response getMetricDefinitionsForGroup(@ApiParam(value="Id of the group") @PathParam(value="id") int var1, @Context Request var2, @Context HttpHeaders var3, @Context UriInfo var4);

    @POST
    @Path(value="/")
    @ApiOperation(value="Create a new group")
    public Response createGroup(@ApiParam(value="A GroupRest object containing at least a name for the group") GroupRest var1, @Context Request var2, @Context HttpHeaders var3, @Context UriInfo var4);

    @PUT
    @Path(value="{id}")
    @ApiOperation(value="Update the passed group")
    public Response updateGroup(@ApiParam(value="Id of the group to update") @PathParam(value="id") int var1, @ApiParam(value="New version of the group") GroupRest var2, @Context Request var3, @Context HttpHeaders var4, @Context UriInfo var5);

    @DELETE
    @Path(value="{id}")
    @ApiOperation(value="Delete the group with the passed id")
    public Response deleteGroup(@ApiParam(value="Id of the group to delete") @PathParam(value="id") int var1, @Context Request var2, @Context HttpHeaders var3, @Context UriInfo var4);

    @GZIP
    @GET
    @Path(value="{id}/resources")
    @Cache(isPrivate=true, maxAge=60)
    @ApiOperation(value="Get the resources of the group", multiValueResponse=true)
    public Response getResources(@ApiParam(value="Id of the group to retrieve the resources for") @PathParam(value="id") int var1, @Context Request var2, @Context HttpHeaders var3, @Context UriInfo var4);

    @PUT
    @Path(value="{id}/resource/{resourceId}")
    @ApiOperation(value="Add a resource to an existing group")
    @ApiErrors(value={@ApiError(code=404, reason="If there is no resource or group with the passed id "), @ApiError(code=409, reason=" Resource type does not match the group one")})
    public Response addResource(@ApiParam(value="Id of the existing group") @PathParam(value="id") int var1, @ApiParam(value="Id of the resource to add") @PathParam(value="resourceId") int var2, @Context Request var3, @Context HttpHeaders var4, @Context UriInfo var5);

    @DELETE
    @Path(value="{id}/resource/{resourceId}")
    @ApiOperation(value="Remove the resource with the passed id from the group")
    public Response removeResource(@ApiParam(value="Id of the existing group") @PathParam(value="id") int var1, @ApiParam(value="Id of the resource to remove") @PathParam(value="resourceId") int var2, @Context Request var3, @Context HttpHeaders var4, @Context UriInfo var5);

    @GZIP
    @GET
    @Path(value="/definitions")
    @ApiOperation(value="List all existing GroupDefinitions", multiValueResponse=true)
    public Response getGroupDefinitions(@Context Request var1, @Context HttpHeaders var2, @Context UriInfo var3);

    @GZIP
    @GET
    @Path(value="/definition/{id}")
    @Cache(isPrivate=true, maxAge=60)
    @ApiOperation(value="Retrieve a single GroupDefinition by id")
    public Response getGroupDefinition(@ApiParam(value="The id of the definition to retrieve") @PathParam(value="id") int var1, @Context Request var2, @Context HttpHeaders var3, @Context UriInfo var4);

    @DELETE
    @Path(value="/definition/{id}")
    @ApiOperation(value="Delete the GroupDefinition with the passed id")
    public Response deleteGroupDefinition(@ApiParam(value="The id of the definition to delete") @PathParam(value="id") int var1, @Context Request var2, @Context HttpHeaders var3, @Context UriInfo var4);

    @POST
    @Path(value="/definitions")
    @Consumes(value={"application/json", "application/xml"})
    @ApiOperation(value="Create a new GroupDefinition. The name of the group is required in the passed definition.")
    public Response createGroupDefinition(GroupDefinitionRest var1, @Context Request var2, @Context HttpHeaders var3, @Context UriInfo var4);

    @PUT
    @Path(value="/definition/{id}")
    @Consumes(value={"application/json", "application/xml"})
    @ApiOperation(value="Update an existing GroupDefinition")
    public Response updateGroupDefinition(@ApiParam(value="Id fo the definition to update") @PathParam(value="id") int var1, @ApiParam(value="If true, trigger a re-calculation") @QueryParam(value="recalculate") @DefaultValue(value="false") boolean var2, GroupDefinitionRest var3, @Context Request var4, @Context HttpHeaders var5, @Context UriInfo var6);
}

