/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.util.updater;

import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class DeployDifferences {
    private final Set<String> ignoredFiles = new HashSet<String>();
    private final Set<String> deletedFiles = new HashSet<String>();
    private final Set<String> addedFiles = new HashSet<String>();
    private final Set<String> changedFiles = new HashSet<String>();
    private final Map<String, String> backedUpFiles = new HashMap<String, String>();
    private final Map<String, String> restoredFiles = new HashMap<String, String>();
    private final Map<String, String> realizedFiles = new HashMap<String, String>();
    private final Map<String, String> errors = new HashMap<String, String>();
    private boolean cleaned = false;

    public void addIgnoredFile(String path) {
        this.ignoredFiles.add(this.convertPath(path));
    }

    public void addIgnoredFiles(Collection<String> paths) {
        for (String path : paths) {
            this.addIgnoredFile(path);
        }
    }

    public void removeIgnoredFile(String path) {
        this.ignoredFiles.remove(this.convertPath(path));
    }

    public boolean containsIgnoredFile(String path) {
        return this.ignoredFiles.contains(this.convertPath(path));
    }

    public void addDeletedFile(String path) {
        this.deletedFiles.add(this.convertPath(path));
    }

    public void addDeletedFiles(Collection<String> paths) {
        for (String path : paths) {
            this.addDeletedFile(path);
        }
    }

    public void removeDeletedFile(String path) {
        this.deletedFiles.remove(this.convertPath(path));
    }

    public boolean containsDeletedFile(String path) {
        return this.deletedFiles.contains(this.convertPath(path));
    }

    public void addAddedFile(String path) {
        this.addedFiles.add(this.convertPath(path));
    }

    public void addAddedFiles(Collection<String> paths) {
        for (String path : paths) {
            this.addAddedFile(path);
        }
    }

    public void removeAddedFile(String path) {
        this.addedFiles.remove(this.convertPath(path));
    }

    public boolean containsAddedFile(String path) {
        return this.addedFiles.contains(this.convertPath(path));
    }

    public void addChangedFile(String path) {
        this.changedFiles.add(this.convertPath(path));
    }

    public void addChangedFiles(Collection<String> paths) {
        for (String path : paths) {
            this.addChangedFile(path);
        }
    }

    public void removeChangedFile(String path) {
        this.changedFiles.remove(this.convertPath(path));
    }

    public boolean containsChangedFile(String path) {
        return this.changedFiles.contains(this.convertPath(path));
    }

    public void addBackedUpFile(String originalPath, String backupPath) {
        this.backedUpFiles.put(this.convertPath(originalPath), this.convertPath(backupPath));
    }

    public void addRestoredFile(String restoredPath, String backupPath) {
        this.restoredFiles.put(this.convertPath(restoredPath), this.convertPath(backupPath));
    }

    public void addRealizedFile(String path, String content) {
        this.realizedFiles.put(this.convertPath(path), content);
    }

    public void addError(String path, String errorMsg) {
        this.errors.put(this.convertPath(path), errorMsg);
    }

    public void setCleaned(boolean cleaned) {
        this.cleaned = cleaned;
    }

    public Set<String> getIgnoredFiles() {
        return this.ignoredFiles;
    }

    public Set<String> getDeletedFiles() {
        return this.deletedFiles;
    }

    public Set<String> getAddedFiles() {
        return this.addedFiles;
    }

    public Set<String> getChangedFiles() {
        return this.changedFiles;
    }

    public Map<String, String> getBackedUpFiles() {
        return this.backedUpFiles;
    }

    public Map<String, String> getRestoredFiles() {
        return this.restoredFiles;
    }

    public Map<String, String> getRealizedFiles() {
        return this.realizedFiles;
    }

    public Map<String, String> getErrors() {
        return this.errors;
    }

    public boolean wasCleaned() {
        return this.cleaned;
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("added=").append(this.addedFiles).append('\n');
        str.append("deleted=").append(this.deletedFiles).append('\n');
        str.append("changed=").append(this.changedFiles).append('\n');
        str.append("ignored=").append(this.ignoredFiles).append('\n');
        str.append("backed-up=").append(this.backedUpFiles).append('\n');
        str.append("restored=").append(this.restoredFiles).append('\n');
        str.append("realized=").append(this.realizedFiles.keySet()).append('\n');
        str.append("cleaned=[").append(this.cleaned).append(']').append('\n');
        str.append("errors=").append(this.errors);
        return str.toString();
    }

    public String convertPath(String path) {
        if (File.separatorChar != '/' && path != null) {
            path = path.replace(File.separatorChar, '/');
        }
        return path;
    }
}

