/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.client.commands;

import gnu.getopt.Getopt;
import gnu.getopt.LongOpt;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Arrays;
import org.rhq.enterprise.client.ClientMain;
import org.rhq.enterprise.client.NoOpRecorder;
import org.rhq.enterprise.client.Recorder;
import org.rhq.enterprise.client.commands.ClientCommand;
import org.rhq.enterprise.client.script.CommandLineParseException;

public class RecordCommand
implements ClientCommand {
    @Override
    public String getPromptCommandString() {
        return "record";
    }

    @Override
    public boolean execute(ClientMain client, String[] cmdLine) {
        String[] cmdLineArgs = Arrays.copyOfRange(cmdLine, 1, cmdLine.length);
        RecordArgs args = this.parseArgs(cmdLineArgs);
        if (args.recordState == RecordState.STOP) {
            this.stopRecording(client);
        } else {
            this.startRecording(client, args);
        }
        return true;
    }

    private RecordArgs parseArgs(String[] args) {
        String shortOpts = "-:f:abe";
        LongOpt[] longOpts = new LongOpt[]{new LongOpt("file", 1, null, 102), new LongOpt("append", 2, null, 97), new LongOpt("start", 2, null, 98), new LongOpt("end", 2, null, 101)};
        Getopt getopt = new Getopt(this.getPromptCommandString(), args, shortOpts, longOpts);
        getopt.setOpterr(false);
        RecordArgs recordArgs = new RecordArgs();
        int code = getopt.getopt();
        while (code != -1) {
            switch (code) {
                case 58: 
                case 63: {
                    throw new CommandLineParseException("Invalid option");
                }
                case 1: {
                    break;
                }
                case 102: {
                    recordArgs.file = new File(getopt.getOptarg());
                    break;
                }
                case 97: {
                    recordArgs.append = true;
                    break;
                }
                case 98: {
                    if (recordArgs.recordState != null) break;
                    recordArgs.recordState = RecordState.START;
                    break;
                }
                case 101: {
                    if (recordArgs.recordState != null) break;
                    recordArgs.recordState = RecordState.STOP;
                }
            }
            code = getopt.getopt();
        }
        if (recordArgs.file == null) {
            throw new CommandLineParseException("The file option must be specified.");
        }
        if (recordArgs.recordState == null) {
            throw new CommandLineParseException("Either the start or stop option must be specified.");
        }
        return recordArgs;
    }

    private void stopRecording(ClientMain client) {
        try {
            client.getRecorder().stop();
            client.setRecorder(new NoOpRecorder());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void startRecording(ClientMain client, RecordArgs args) {
        try {
            Recorder recorder = new Recorder();
            recorder.setWriter(new FileWriter(args.file, args.append));
            client.setRecorder(recorder);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public String getSyntax() {
        return this.getPromptCommandString() + " [[-b | --start] | [-e | --end]] [-a | --append] -f <file>";
    }

    @Override
    public String getHelp() {
        return "Record user input commands to a specified file. Use the --start option to begin recording. Use the --end option to stop recording. Use --append to append output to the end of an existing file; otherwise, recording will start at the beginning of the file.";
    }

    @Override
    public String getDetailedHelp() {
        return this.getHelp();
    }

    private static enum RecordState {
        START,
        STOP;

    }

    private static class RecordArgs {
        boolean append;
        File file;
        RecordState recordState;

        private RecordArgs() {
        }
    }
}

