/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.clientapi;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.bindings.StandardBindings;
import org.rhq.bindings.client.RhqFacade;
import org.rhq.bindings.script.BaseRhqSchemeScriptSourceProvider;
import org.rhq.enterprise.clientapi.RemoteClient;
import org.rhq.enterprise.communications.util.SecurityUtil;

public class RhqDownloadsScriptSourceProvider
extends BaseRhqSchemeScriptSourceProvider
implements StandardBindings.RhqFacadeChangeListener {
    private static final Log LOG = LogFactory.getLog(RhqDownloadsScriptSourceProvider.class);
    private static final String AUTHORITY = "downloads";
    private static final String URL_PATH_PREFIX = "/downloads/script-modules";
    private RemoteClient remoteClient;

    public RhqDownloadsScriptSourceProvider() {
        super(AUTHORITY);
    }

    public void rhqFacadeChanged(StandardBindings bindings) {
        RhqFacade facade = bindings.getAssociatedRhqFacade();
        this.remoteClient = facade instanceof RemoteClient ? (RemoteClient)facade : null;
    }

    protected Reader doGetScriptSource(URI scriptUri) {
        if (this.remoteClient == null) {
            return null;
        }
        String path = scriptUri.getPath();
        URI remoteUri = this.remoteClient.getRemoteURI().resolve(URL_PATH_PREFIX + path);
        String replacementScheme = SecurityUtil.isTransportSecure((String)remoteUri.getScheme()) ? "https" : "http";
        try {
            remoteUri = new URI(replacementScheme, remoteUri.getAuthority(), remoteUri.getPath(), remoteUri.getQuery(), remoteUri.getFragment());
        }
        catch (URISyntaxException e) {
            LOG.error((Object)("Failed to copy the RHQ server download URI: " + remoteUri + " to the " + replacementScheme + " scheme."));
        }
        try {
            URL downloadUrl = remoteUri.toURL();
            return new InputStreamReader(downloadUrl.openStream());
        }
        catch (MalformedURLException e) {
            LOG.debug((Object)("Failed to download the script from the RHQ server using URL: " + remoteUri), (Throwable)e);
        }
        catch (IOException e) {
            LOG.debug((Object)("Failed to download the script from the RHQ server using URL: " + remoteUri), (Throwable)e);
        }
        return null;
    }
}

