/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.util.exec;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class StreamRedirectorRunnable
implements Runnable {
    private final InputStream m_input;
    private final OutputStream m_output;
    private final String m_name;

    public StreamRedirectorRunnable(String name, InputStream is, OutputStream os) throws IllegalArgumentException {
        if (is == null) {
            throw new IllegalArgumentException("is=null");
        }
        this.m_name = name;
        this.m_input = is;
        this.m_output = os;
    }

    @Override
    public void run() {
        Thread t = Thread.currentThread();
        t.setName(this.m_name);
        int bufferSize = 4096;
        byte[] buffer = new byte[4096];
        boolean keepGoing = true;
        try {
            while (keepGoing) {
                int read = this.m_input.read(buffer, 0, 4096);
                if (read > 0) {
                    if (this.m_output == null) continue;
                    this.m_output.write(buffer, 0, read);
                    continue;
                }
                keepGoing = false;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.m_input.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            if (this.m_output != null) {
                this.m_output.close();
            }
        }
        catch (IOException e) {
            // empty catch block
        }
    }
}

