/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.alert.engine.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.rhq.core.domain.alert.AlertCondition;
import org.rhq.core.domain.alert.AlertConditionCategory;
import org.rhq.core.domain.alert.AlertConditionOperator;
import org.rhq.core.domain.alert.composite.AbstractAlertConditionCategoryComposite;
import org.rhq.core.domain.alert.composite.AlertConditionBaselineCategoryComposite;
import org.rhq.core.domain.alert.composite.AlertConditionChangesCategoryComposite;
import org.rhq.core.domain.alert.composite.AlertConditionDriftCategoryComposite;
import org.rhq.core.domain.alert.composite.AlertConditionEventCategoryComposite;
import org.rhq.core.domain.alert.composite.AlertConditionRangeCategoryComposite;
import org.rhq.core.domain.alert.composite.AlertConditionScheduleCategoryComposite;
import org.rhq.core.domain.alert.composite.AlertConditionTraitCategoryComposite;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.event.Event;
import org.rhq.core.domain.event.EventSeverity;
import org.rhq.core.domain.event.EventSource;
import org.rhq.core.domain.measurement.DataType;
import org.rhq.core.domain.measurement.MeasurementData;
import org.rhq.core.domain.measurement.MeasurementDataNumeric;
import org.rhq.core.domain.measurement.MeasurementDataTrait;
import org.rhq.core.domain.measurement.calltime.CallTimeData;
import org.rhq.core.domain.measurement.calltime.CallTimeDataValue;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.util.PageControl;
import org.rhq.core.domain.util.PageList;
import org.rhq.enterprise.server.alert.AlertConditionManagerLocal;
import org.rhq.enterprise.server.alert.engine.AlertConditionCacheStats;
import org.rhq.enterprise.server.alert.engine.internal.AbstractConditionCache;
import org.rhq.enterprise.server.alert.engine.internal.AlertConditionCacheCoordinator;
import org.rhq.enterprise.server.alert.engine.internal.AlertConditionCacheUtils;
import org.rhq.enterprise.server.alert.engine.mbean.AlertConditionCacheMonitor;
import org.rhq.enterprise.server.alert.engine.model.CallTimeDataCacheElement;
import org.rhq.enterprise.server.alert.engine.model.DriftCacheElement;
import org.rhq.enterprise.server.alert.engine.model.EventCacheElement;
import org.rhq.enterprise.server.alert.engine.model.InvalidCacheElementException;
import org.rhq.enterprise.server.alert.engine.model.MeasurementBaselineCacheElement;
import org.rhq.enterprise.server.alert.engine.model.MeasurementNumericCacheElement;
import org.rhq.enterprise.server.alert.engine.model.MeasurementRangeNumericCacheElement;
import org.rhq.enterprise.server.alert.engine.model.MeasurementTraitCacheElement;
import org.rhq.enterprise.server.alert.engine.model.NumericDoubleCacheElement;
import org.rhq.enterprise.server.auth.SubjectManagerLocal;
import org.rhq.enterprise.server.measurement.MeasurementDataManagerLocal;
import org.rhq.enterprise.server.plugin.pc.drift.DriftChangeSetSummary;
import org.rhq.enterprise.server.util.LookupUtil;

class AgentConditionCache
extends AbstractConditionCache {
    private Map<Integer, List<NumericDoubleCacheElement>> measurementDataCache;
    private Map<Integer, List<MeasurementTraitCacheElement>> measurementTraitCache;
    private Map<Integer, List<CallTimeDataCacheElement>> callTimeCache;
    private Map<Integer, List<EventCacheElement>> eventsCache;
    private Map<Integer, List<DriftCacheElement>> driftCache;
    private AlertConditionManagerLocal alertConditionManager;
    private MeasurementDataManagerLocal measurementDataManager;
    private SubjectManagerLocal subjectManager;
    private int agentId;

    public AgentConditionCache(int agentId) {
        this.agentId = agentId;
        this.measurementDataCache = new HashMap<Integer, List<NumericDoubleCacheElement>>();
        this.measurementTraitCache = new HashMap<Integer, List<MeasurementTraitCacheElement>>();
        this.callTimeCache = new HashMap<Integer, List<CallTimeDataCacheElement>>();
        this.eventsCache = new HashMap<Integer, List<EventCacheElement>>();
        this.driftCache = new HashMap<Integer, List<DriftCacheElement>>();
        this.alertConditionManager = LookupUtil.getAlertConditionManager();
        this.measurementDataManager = LookupUtil.getMeasurementDataManager();
        this.subjectManager = LookupUtil.getSubjectManager();
        this.loadCachesForAgent(agentId);
    }

    private AlertConditionCacheStats loadCachesForAgent(int agentId) {
        AlertConditionCacheStats stats = new AlertConditionCacheStats();
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Loading Alert Condition Caches for agent[id=" + agentId + "]..."));
            }
            Subject overlord = this.subjectManager.getOverlord();
            EnumSet<AlertConditionCategory[]> supportedCategories = EnumSet.of(AlertConditionCategory.BASELINE, new AlertConditionCategory[]{AlertConditionCategory.CHANGE, AlertConditionCategory.TRAIT, AlertConditionCategory.THRESHOLD, AlertConditionCategory.EVENT, AlertConditionCategory.DRIFT, AlertConditionCategory.RANGE});
            for (AlertConditionCategory alertConditionCategory : supportedCategories) {
                int rowsProcessed = 0;
                PageControl pc = new PageControl();
                pc.setPageNumber(0);
                pc.setPageSize(250);
                while (true) {
                    PageList<? extends AbstractAlertConditionCategoryComposite> alertConditions = null;
                    alertConditions = this.alertConditionManager.getAlertConditionComposites(overlord, agentId, alertConditionCategory, pc);
                    if (alertConditions.isEmpty()) break;
                    for (AbstractAlertConditionCategoryComposite nextComposite : alertConditions) {
                        this.insertAlertConditionComposite(agentId, nextComposite, stats);
                    }
                    if ((rowsProcessed += alertConditions.size()) >= alertConditions.getTotalSize()) break;
                    pc.setPageNumber(pc.getPageNumber() + 1);
                }
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Loaded " + rowsProcessed + " Alert Condition Composites of type '" + alertConditionCategory + "'"));
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Loaded Alert Condition Caches for agent[id=" + agentId + "]"));
            }
        }
        catch (Throwable t) {
            log.error((Object)("Error loading cache for agent[id=" + agentId + "]"), t);
        }
        return stats;
    }

    private void insertAlertConditionComposite(int agentId, AbstractAlertConditionCategoryComposite composite, AlertConditionCacheStats stats) {
        AlertCondition alertCondition = composite.getCondition();
        int alertConditionId = alertCondition.getId();
        AlertConditionCategory alertConditionCategory = alertCondition.getCategory();
        AlertConditionOperator alertConditionOperator = AlertConditionCacheUtils.getAlertConditionOperator(alertCondition);
        if (DataType.CALLTIME == composite.getDataType()) {
            if (alertConditionCategory == AlertConditionCategory.CHANGE) {
                AlertConditionChangesCategoryComposite changesComposite = (AlertConditionChangesCategoryComposite)composite;
                int scheduleId = changesComposite.getScheduleId();
                try {
                    CallTimeDataCacheElement cacheElement = new CallTimeDataCacheElement(alertConditionOperator, CallTimeDataCacheElement.CallTimeElementValue.valueOf(alertCondition.getOption()), alertCondition.getComparator(), alertCondition.getThreshold(), alertConditionId, alertCondition.getName());
                    this.addTo("callTimeDataCache", this.callTimeCache, scheduleId, cacheElement, alertConditionId, stats);
                }
                catch (InvalidCacheElementException icee) {
                    log.info((Object)("Failed to create CallTimeDataCacheElement with parameters: " + AlertConditionCacheUtils.getCacheElementErrorString(alertConditionId, alertConditionOperator, null, alertCondition.getThreshold(), icee)));
                }
            } else if (alertConditionCategory == AlertConditionCategory.THRESHOLD) {
                AlertConditionScheduleCategoryComposite thresholdComposite = (AlertConditionScheduleCategoryComposite)composite;
                try {
                    CallTimeDataCacheElement cacheElement = new CallTimeDataCacheElement(alertConditionOperator, CallTimeDataCacheElement.CallTimeElementValue.valueOf(alertCondition.getOption()), null, alertCondition.getThreshold(), alertConditionId, alertCondition.getName());
                    this.addTo("measurementDataCache", this.callTimeCache, thresholdComposite.getScheduleId(), cacheElement, alertConditionId, stats);
                }
                catch (InvalidCacheElementException icee) {
                    log.info((Object)("Failed to create CallTimeDataCacheElement with parameters: " + AlertConditionCacheUtils.getCacheElementErrorString(alertConditionId, alertConditionOperator, null, alertCondition.getThreshold(), icee)));
                }
            }
        } else if (alertConditionCategory == AlertConditionCategory.BASELINE) {
            AlertConditionBaselineCategoryComposite baselineComposite = (AlertConditionBaselineCategoryComposite)composite;
            Double threshold = alertCondition.getThreshold();
            String optionStatus = alertCondition.getOption();
            Double calculatedValue = this.getCalculatedBaselineValue(alertConditionId, baselineComposite, optionStatus, threshold);
            try {
                MeasurementBaselineCacheElement cacheElement = new MeasurementBaselineCacheElement(alertConditionOperator, calculatedValue, alertConditionId, optionStatus);
                this.addTo("measurementDataCache", this.measurementDataCache, baselineComposite.getScheduleId(), cacheElement, alertConditionId, stats);
            }
            catch (InvalidCacheElementException icee) {
                log.info((Object)("Failed to create MeasurementBaselineCacheElement with parameters: " + AlertConditionCacheUtils.getCacheElementErrorString(alertConditionId, alertConditionOperator, null, calculatedValue, icee)));
            }
        } else if (alertConditionCategory == AlertConditionCategory.CHANGE) {
            AlertConditionChangesCategoryComposite changesComposite = (AlertConditionChangesCategoryComposite)composite;
            int scheduleId = changesComposite.getScheduleId();
            MeasurementDataNumeric numeric = this.measurementDataManager.getCurrentNumericForSchedule(scheduleId);
            try {
                MeasurementNumericCacheElement cacheElement = new MeasurementNumericCacheElement(alertConditionOperator, numeric == null ? null : numeric.getValue(), alertConditionId);
                this.addTo("measurementDataCache", this.measurementDataCache, scheduleId, cacheElement, alertConditionId, stats);
            }
            catch (InvalidCacheElementException icee) {
                log.info((Object)("Failed to create MeasurementNumericCacheElement with parameters: " + AlertConditionCacheUtils.getCacheElementErrorString(alertConditionId, alertConditionOperator, null, numeric, icee)));
            }
        } else if (alertConditionCategory == AlertConditionCategory.TRAIT) {
            AlertConditionTraitCategoryComposite traitsComposite = (AlertConditionTraitCategoryComposite)composite;
            String value = null;
            switch (alertConditionOperator) {
                case CHANGES: {
                    value = traitsComposite.getValue();
                    break;
                }
                case REGEX: {
                    value = traitsComposite.getCondition().getOption();
                    break;
                }
                default: {
                    log.error((Object)("Invalid operator for Trait condition: " + alertConditionOperator));
                }
            }
            try {
                MeasurementTraitCacheElement cacheElement = new MeasurementTraitCacheElement(alertConditionOperator, value, alertConditionId);
                this.addTo("measurementTraitCache", this.measurementTraitCache, traitsComposite.getScheduleId(), cacheElement, alertConditionId, stats);
            }
            catch (InvalidCacheElementException icee) {
                log.info((Object)("Failed to create MeasurementTraitCacheElement with parameters: " + AlertConditionCacheUtils.getCacheElementErrorString(alertConditionId, alertConditionOperator, null, value, icee)));
            }
        } else if (alertConditionCategory == AlertConditionCategory.THRESHOLD) {
            AlertConditionScheduleCategoryComposite thresholdComposite = (AlertConditionScheduleCategoryComposite)composite;
            Double thresholdValue = alertCondition.getThreshold();
            MeasurementNumericCacheElement cacheElement = null;
            try {
                cacheElement = new MeasurementNumericCacheElement(alertConditionOperator, thresholdValue, alertConditionId);
            }
            catch (InvalidCacheElementException icee) {
                log.info((Object)("Failed to create MeasurementNumericCacheElement with parameters: " + AlertConditionCacheUtils.getCacheElementErrorString(alertConditionId, alertConditionOperator, null, thresholdValue, icee)));
            }
            if (cacheElement != null) {
                this.addTo("measurementDataCache", this.measurementDataCache, thresholdComposite.getScheduleId(), cacheElement, alertConditionId, stats);
            }
        } else if (alertConditionCategory == AlertConditionCategory.EVENT) {
            AlertConditionEventCategoryComposite eventComposite = (AlertConditionEventCategoryComposite)composite;
            EventSeverity eventSeverity = EventSeverity.valueOf((String)alertCondition.getName());
            String eventDetails = alertCondition.getOption();
            EventCacheElement cacheElement = null;
            try {
                cacheElement = eventDetails == null ? new EventCacheElement(alertConditionOperator, eventSeverity, alertConditionId) : new EventCacheElement(alertConditionOperator, eventDetails, eventSeverity, alertConditionId);
            }
            catch (InvalidCacheElementException icee) {
                log.info((Object)("Failed to create EventCacheElement with parameters: " + AlertConditionCacheUtils.getCacheElementErrorString(alertConditionId, alertConditionOperator, eventDetails, eventSeverity, icee)));
            }
            this.addTo("eventsCache", this.eventsCache, eventComposite.getResourceId(), cacheElement, alertConditionId, stats);
        } else if (alertConditionCategory == AlertConditionCategory.DRIFT) {
            AlertConditionDriftCategoryComposite driftComposite = (AlertConditionDriftCategoryComposite)composite;
            String driftDefNameRegexStr = driftComposite.getCondition().getName();
            String driftPathNameRegexStr = driftComposite.getCondition().getOption();
            DriftCacheElement cacheElement = null;
            try {
                cacheElement = new DriftCacheElement(alertConditionOperator, driftDefNameRegexStr, driftPathNameRegexStr, alertConditionId);
            }
            catch (InvalidCacheElementException icee) {
                log.info((Object)("Failed to create DriftCacheElement: id=" + alertConditionId + ", operator=" + alertConditionOperator + ", driftDefNameRegex=" + driftDefNameRegexStr + ", driftPathNameRegex=" + driftPathNameRegexStr));
            }
            this.addTo("driftCache", this.driftCache, driftComposite.getResourceId(), cacheElement, alertConditionId, stats);
        } else if (alertConditionCategory == AlertConditionCategory.RANGE) {
            AlertConditionRangeCategoryComposite rangeComposite = (AlertConditionRangeCategoryComposite)composite;
            Double loValue = alertCondition.getThreshold();
            String hiValueStr = alertCondition.getOption();
            MeasurementRangeNumericCacheElement cacheElement = null;
            try {
                if (hiValueStr == null) {
                    throw new NumberFormatException("The range alert condition is missing the high value");
                }
                Double hiValue = Double.valueOf(hiValueStr);
                cacheElement = new MeasurementRangeNumericCacheElement(alertConditionOperator, loValue, hiValue, alertConditionId);
            }
            catch (InvalidCacheElementException icee) {
                log.info((Object)("Failed to create MeasurementRangeNumericCacheElement with parameters: " + AlertConditionCacheUtils.getCacheElementErrorString(alertConditionId, alertConditionOperator, hiValueStr, loValue, icee)));
            }
            catch (NumberFormatException nfe) {
                log.info((Object)("Failed to create MeasurementRangeNumericCacheElement with parameters: " + AlertConditionCacheUtils.getCacheElementErrorString(alertConditionId, alertConditionOperator, hiValueStr, loValue, nfe)));
            }
            if (cacheElement != null) {
                this.addTo("measurementDataCache", this.measurementDataCache, rangeComposite.getScheduleId(), cacheElement, alertConditionId, stats);
            }
        }
    }

    public AlertConditionCacheStats checkConditions(MeasurementData ... measurementData) {
        if (measurementData == null || measurementData.length == 0) {
            return new AlertConditionCacheStats();
        }
        AlertConditionCacheStats stats = new AlertConditionCacheStats();
        try {
            for (MeasurementData datum : measurementData) {
                int scheduleId = datum.getScheduleId();
                if (datum instanceof MeasurementDataNumeric) {
                    List<? extends NumericDoubleCacheElement> conditionCacheElements = this.lookupMeasurementDataCacheElements(scheduleId);
                    Double providedValue = ((MeasurementDataNumeric)datum).getValue();
                    this.processCacheElements(conditionCacheElements, providedValue, datum.getTimestamp(), stats, new Object[0]);
                    continue;
                }
                if (datum instanceof MeasurementDataTrait) {
                    List<MeasurementTraitCacheElement> cacheElements = this.lookupMeasurementTraitCacheElements(scheduleId);
                    this.processCacheElements(cacheElements, ((MeasurementDataTrait)datum).getValue(), datum.getTimestamp(), stats, new Object[0]);
                    continue;
                }
                log.error((Object)(this.getClass().getSimpleName() + " does not support " + "checking conditions against " + datum.getClass().getSimpleName() + " types"));
            }
            AlertConditionCacheMonitor.getMBean().incrementMeasurementCacheElementMatches(stats.matched);
            AlertConditionCacheMonitor.getMBean().incrementMeasurementProcessingTime(stats.getAge());
            if (log.isDebugEnabled()) {
                log.debug((Object)("Check Measurements[size=" + measurementData.length + "] - " + stats));
            }
        }
        catch (Throwable t) {
            log.error((Object)("Error during measurement data cache processing for agent[id=" + this.agentId + "]"), t);
        }
        return stats;
    }

    public AlertConditionCacheStats checkConditions(CallTimeData ... callTime) {
        if (callTime == null || callTime.length == 0) {
            return new AlertConditionCacheStats();
        }
        AlertConditionCacheStats stats = new AlertConditionCacheStats();
        try {
            HashMap<Integer, HashMap<String, ArrayList<CallTimeDataValue>>> order = this.produceOrderedCallTimeDataStructure(callTime);
            for (Integer scheduleId : order.keySet()) {
                List<? extends CallTimeDataCacheElement> conditionCacheElements = this.lookupCallTimeDataCacheElements(scheduleId);
                for (String callDest : order.get(scheduleId).keySet()) {
                    for (CallTimeDataValue provided : order.get(scheduleId).get(callDest)) {
                        this.processCacheElements(conditionCacheElements, provided, provided.getBeginTime(), stats, callDest);
                    }
                }
            }
            AlertConditionCacheMonitor.getMBean().incrementCallTimeCacheElementMatches(stats.matched);
            AlertConditionCacheMonitor.getMBean().incrementCallTimeProcessingTime(stats.getAge());
        }
        catch (Throwable t) {
            log.error((Object)("Error during calltime cache processing for agent[id=" + this.agentId + "]"), t);
        }
        return stats;
    }

    private HashMap<Integer, HashMap<String, ArrayList<CallTimeDataValue>>> produceOrderedCallTimeDataStructure(CallTimeData ... callTime) {
        long beginTime = 0L;
        if (log.isDebugEnabled()) {
            beginTime = System.nanoTime();
        }
        HashMap<Integer, HashMap<String, ArrayList<CallTimeDataValue>>> order = new HashMap<Integer, HashMap<String, ArrayList<CallTimeDataValue>>>();
        for (CallTimeData ctd : callTime) {
            if (!order.containsKey(ctd.getScheduleId())) {
                order.put(ctd.getScheduleId(), new HashMap());
            }
            HashMap<String, ArrayList<CallTimeDataValue>> partialOrder = order.get(ctd.getScheduleId());
            for (String callDestination : ctd.getValues().keySet()) {
                if (!partialOrder.containsKey(callDestination)) {
                    partialOrder.put(callDestination, new ArrayList());
                }
                ArrayList<CallTimeDataValue> list = partialOrder.get(callDestination);
                list.add((CallTimeDataValue)ctd.getValues().get(callDestination));
            }
        }
        for (HashMap topList : order.values()) {
            for (ArrayList bottomList : topList.values()) {
                Collections.sort(bottomList, this.getCallTimeComparator());
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("sorting call-time data during alerting took: " + TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - beginTime) + "ms"));
        }
        return order;
    }

    private Comparator<CallTimeDataValue> getCallTimeComparator() {
        return new Comparator<CallTimeDataValue>(){

            @Override
            public int compare(CallTimeDataValue arg0, CallTimeDataValue arg1) {
                if (arg0 == null || arg1 == null) {
                    throw new IllegalArgumentException("Call-time data value entries must not be null!");
                }
                if (arg0 == arg1) {
                    return 0;
                }
                if (arg0.getBeginTime() < arg1.getBeginTime()) {
                    return -1;
                }
                if (arg0.getBeginTime() > arg1.getBeginTime()) {
                    return 1;
                }
                if (arg0.getBeginTime() == arg1.getBeginTime()) {
                    if (arg0.getEndTime() == arg1.getEndTime()) {
                        return 0;
                    }
                    if (arg0.getEndTime() < arg1.getEndTime()) {
                        return -1;
                    }
                    if (arg0.getEndTime() > arg1.getEndTime()) {
                        return 1;
                    }
                }
                return Integer.MIN_VALUE;
            }
        };
    }

    public AlertConditionCacheStats checkConditions(EventSource source, Event ... events) {
        if (events == null || events.length == 0) {
            return new AlertConditionCacheStats();
        }
        AlertConditionCacheStats stats = new AlertConditionCacheStats();
        try {
            Resource resource = source.getResource();
            List<EventCacheElement> cacheElements = this.lookupEventCacheElements(resource.getId());
            for (Event event : events) {
                this.processCacheElements(cacheElements, event.getSeverity(), event.getTimestamp(), stats, event.getDetail());
            }
            AlertConditionCacheMonitor.getMBean().incrementEventCacheElementMatches(stats.matched);
            AlertConditionCacheMonitor.getMBean().incrementEventProcessingTime(stats.getAge());
            if (log.isDebugEnabled()) {
                log.debug((Object)("Check Events[size=" + events.length + "] - " + stats));
            }
        }
        catch (Throwable t) {
            log.error((Object)("Error during event cache processing for agent[id=" + this.agentId + "]"), t);
        }
        return stats;
    }

    public AlertConditionCacheStats checkConditions(DriftChangeSetSummary driftChangeSetSummary) {
        AlertConditionCacheStats stats = new AlertConditionCacheStats();
        try {
            int resourceId = driftChangeSetSummary.getResourceId();
            List<DriftCacheElement> cacheElements = this.lookupDriftCacheElements(resourceId);
            this.processCacheElements(cacheElements, DriftCacheElement.UNUSED_CONDITION_VALUE, driftChangeSetSummary.getCreatedTime(), stats, driftChangeSetSummary);
            AlertConditionCacheMonitor.getMBean().incrementDriftCacheElementMatches(stats.matched);
            AlertConditionCacheMonitor.getMBean().incrementDriftProcessingTime(stats.getAge());
            if (log.isDebugEnabled()) {
                log.debug((Object)("Check Drift[resourceId=" + resourceId + "] - " + stats));
            }
        }
        catch (Throwable t) {
            log.error((Object)("Error during drift cache processing for agent[id=" + this.agentId + "]"), t);
        }
        return stats;
    }

    private List<? extends NumericDoubleCacheElement> lookupMeasurementDataCacheElements(int scheduleId) {
        return this.measurementDataCache.get(scheduleId);
    }

    private List<? extends CallTimeDataCacheElement> lookupCallTimeDataCacheElements(int scheduleId) {
        return this.callTimeCache.get(scheduleId);
    }

    private List<MeasurementTraitCacheElement> lookupMeasurementTraitCacheElements(int scheduleId) {
        return this.measurementTraitCache.get(scheduleId);
    }

    private List<EventCacheElement> lookupEventCacheElements(int resourceId) {
        return this.eventsCache.get(resourceId);
    }

    private List<DriftCacheElement> lookupDriftCacheElements(int resourceId) {
        return this.driftCache.get(resourceId);
    }

    private Double getCalculatedBaselineValue(int conditionId, AlertConditionBaselineCategoryComposite composite, String optionStatus, Double threshold) {
        int baselineId = composite.getBaselineId();
        if (AlertConditionCacheUtils.isInvalidDouble(threshold)) {
            log.error((Object)("Failed to calculate baseline for [conditionId=" + conditionId + ", baselineId=" + baselineId + "]: threshold was null"));
        }
        Double baselineValue = 0.0;
        if (optionStatus == null) {
            log.error((Object)("Failed to calculate baseline for [conditionId=" + conditionId + ", baselineId=" + baselineId + "]: optionStatus string was null"));
        } else if (optionStatus.equals("min")) {
            baselineValue = composite.getMinValue();
        } else if (optionStatus.equals("mean")) {
            baselineValue = composite.getMeanValue();
        } else if (optionStatus.equals("max")) {
            baselineValue = composite.getMaxValue();
        } else {
            log.error((Object)("Failed to calculate baseline for [conditionId=" + conditionId + ", baselineId=" + baselineId + "]: unrecognized optionStatus string of '" + optionStatus + "'"));
            return null;
        }
        if (AlertConditionCacheUtils.isInvalidDouble(baselineValue)) {
            log.error((Object)("Failed to calculate baseline for [conditionId=" + conditionId + ", baselineId=" + baselineId + "]: optionStatus string was '" + optionStatus + "', but the corresponding baseline value was null"));
        }
        return threshold * baselineValue;
    }

    @Override
    public int getCacheSize(AlertConditionCacheCoordinator.Cache cache) {
        if (cache == AlertConditionCacheCoordinator.Cache.MeasurementDataCache) {
            return AlertConditionCacheUtils.getMapListCount(this.measurementDataCache);
        }
        if (cache == AlertConditionCacheCoordinator.Cache.MeasurementTraitCache) {
            return AlertConditionCacheUtils.getMapListCount(this.measurementTraitCache);
        }
        if (cache == AlertConditionCacheCoordinator.Cache.CallTimeDataCache) {
            return AlertConditionCacheUtils.getMapListCount(this.callTimeCache);
        }
        if (cache == AlertConditionCacheCoordinator.Cache.EventsCache) {
            return AlertConditionCacheUtils.getMapListCount(this.eventsCache);
        }
        if (cache == AlertConditionCacheCoordinator.Cache.DriftCache) {
            return AlertConditionCacheUtils.getMapListCount(this.driftCache);
        }
        throw new IllegalArgumentException("The " + AgentConditionCache.class.getSimpleName() + " either does not manage caches of type " + (Object)((Object)cache.type) + ", or does not support obtaining their size");
    }
}

