/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.alert.engine.internal;

import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.alert.AlertCondition;
import org.rhq.core.domain.alert.AlertConditionCategory;
import org.rhq.core.domain.alert.AlertConditionOperator;
import org.rhq.enterprise.server.alert.engine.internal.AlertConditionCacheCoordinator;
import org.rhq.enterprise.server.alert.engine.model.AbstractCacheElement;
import org.rhq.enterprise.server.alert.engine.model.UnsupportedAlertConditionOperatorException;

class AlertConditionCacheUtils {
    private static final Log log = LogFactory.getLog(AlertConditionCacheCoordinator.class);

    AlertConditionCacheUtils() {
    }

    public static AlertConditionOperator getAlertConditionOperator(AlertCondition alertCondition) {
        AlertConditionCategory category = alertCondition.getCategory();
        String name = alertCondition.getName();
        String comparator = alertCondition.getComparator();
        switch (category) {
            case CONTROL: {
                return AlertConditionOperator.EQUALS;
            }
            case EVENT: {
                return AlertConditionOperator.GREATER_THAN_OR_EQUAL_TO;
            }
            case DRIFT: {
                return AlertConditionOperator.CHANGES;
            }
            case RESOURCE_CONFIG: 
            case CHANGE: {
                return AlertConditionOperator.CHANGES;
            }
            case TRAIT: {
                String regex = alertCondition.getOption();
                return null == regex || regex.isEmpty() ? AlertConditionOperator.CHANGES : AlertConditionOperator.REGEX;
            }
            case AVAILABILITY: {
                AlertConditionOperator operator = AlertConditionOperator.valueOf((String)name.toUpperCase());
                switch (operator) {
                    case AVAIL_GOES_DISABLED: 
                    case AVAIL_GOES_DOWN: 
                    case AVAIL_GOES_UNKNOWN: 
                    case AVAIL_GOES_UP: 
                    case AVAIL_GOES_NOT_UP: {
                        return operator;
                    }
                }
                throw new UnsupportedAlertConditionOperatorException("Invalid alertConditionValue for AVAILABILITY category:" + operator);
            }
            case AVAIL_DURATION: {
                AlertConditionOperator operator = AlertConditionOperator.valueOf((String)name.toUpperCase());
                switch (operator) {
                    case AVAIL_DURATION_DOWN: 
                    case AVAIL_DURATION_NOT_UP: {
                        return operator;
                    }
                }
                throw new UnsupportedAlertConditionOperatorException("Invalid alertConditionValue for AVAILABILITY_DURATION category:" + operator);
            }
            case RANGE: {
                if (comparator.equals("<=")) {
                    return AlertConditionOperator.LESS_THAN_OR_EQUAL_TO;
                }
                if (comparator.equals(">=")) {
                    return AlertConditionOperator.GREATER_THAN_OR_EQUAL_TO;
                }
                if (!comparator.equals("=")) break;
                throw new UnsupportedAlertConditionOperatorException("Comparator [" + comparator + "] " + "is not supported for category: " + category.name());
            }
        }
        if (comparator.equals("<")) {
            return AlertConditionOperator.LESS_THAN;
        }
        if (comparator.equals(">")) {
            return AlertConditionOperator.GREATER_THAN;
        }
        if (comparator.equals("=")) {
            return AlertConditionOperator.EQUALS;
        }
        throw new UnsupportedAlertConditionOperatorException("Comparator [" + comparator + "] " + "is not supported for category: " + category.name());
    }

    public static String getCacheElementErrorString(int conditionId, AlertConditionOperator operator, Object option, Object value, Throwable exception) {
        return "id=" + conditionId + ", " + "operator=" + operator + ", " + (option != null ? "option=" + option + ", " : "") + "value=" + value + ", error message: " + exception.getMessage();
    }

    public static <T extends AbstractCacheElement<?>> void printListCache(String cacheName, Map<Integer, List<T>> cache) {
        log.debug((Object)("Printing " + cacheName + "..."));
        for (Map.Entry<Integer, List<T>> cacheElement : cache.entrySet()) {
            log.debug((Object)("key=" + cacheElement.getKey() + ", " + "value=" + cacheElement.getValue()));
        }
    }

    public static <T extends AbstractCacheElement<?>> void printNestedCache(String cacheName, Map<Integer, Map<Integer, List<T>>> nestedCache) {
        log.debug((Object)("Printing " + cacheName + "..."));
        for (Map.Entry<Integer, Map<Integer, List<T>>> cache : nestedCache.entrySet()) {
            for (Map.Entry<Integer, List<T>> cacheElement : cache.getValue().entrySet()) {
                log.debug((Object)("key1=" + cache.getKey() + ", " + "key2=" + cacheElement.getKey() + ", " + "value=" + cacheElement.getValue()));
            }
        }
    }

    public static boolean isInvalidDouble(Double d) {
        return d == null || Double.isNaN(d) || d == Double.POSITIVE_INFINITY || d == Double.NEGATIVE_INFINITY;
    }

    public static <S, T> int getMapListCount(Map<S, List<T>> mapList) {
        int count = 0;
        try {
            for (List<T> listValue : mapList.values()) {
                count += listValue.size();
            }
        }
        catch (Throwable t) {
            log.error((Object)"Error counting MapList", t);
        }
        return count;
    }

    public static <R, S, T> int getMapMapListCount(Map<R, Map<S, List<T>>> mapMapList) {
        int count = 0;
        try {
            for (Map<S, List<T>> mapListValue : mapMapList.values()) {
                count += AlertConditionCacheUtils.getMapListCount(mapListValue);
            }
        }
        catch (Throwable t) {
            log.error((Object)"Error counting MapMapList", t);
        }
        return count;
    }
}

