/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.cloud;

import java.net.InetAddress;
import java.util.List;
import java.util.Map;
import javax.ejb.Local;
import org.rhq.core.domain.alert.Alert;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.cloud.StorageClusterSettings;
import org.rhq.core.domain.cloud.StorageNode;
import org.rhq.core.domain.cloud.StorageNodeConfigurationComposite;
import org.rhq.core.domain.cloud.StorageNodeLoadComposite;
import org.rhq.core.domain.criteria.StorageNodeCriteria;
import org.rhq.core.domain.measurement.composite.MeasurementDataNumericHighLowComposite;
import org.rhq.core.domain.operation.bean.ResourceOperationSchedule;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.util.PageList;

@Local
public interface StorageNodeManagerLocal {
    public static final String STORAGE_NODE_GROUP_NAME = "RHQ Storage Nodes";
    public static final String STORAGE_NODE_RESOURCE_TYPE_NAME = "RHQ Storage Node";
    public static final String STORAGE_NODE_PLUGIN_NAME = "RHQStorage";

    public List<StorageNode> getStorageNodes();

    public List<StorageNode> getClusterNodes();

    public PageList<StorageNodeLoadComposite> getStorageNodeComposites();

    public void linkResource(Resource var1);

    public StorageNodeLoadComposite getLoad(Subject var1, StorageNode var2, long var3, long var5);

    public StorageNodeConfigurationComposite retrieveConfiguration(Subject var1, StorageNode var2);

    public boolean updateConfiguration(Subject var1, StorageNodeConfigurationComposite var2);

    public void updateConfigurationAsync(Subject var1, StorageNodeConfigurationComposite var2);

    public PageList<StorageNode> findStorageNodesByCriteria(Subject var1, StorageNodeCriteria var2);

    public PageList<Alert> findNotAcknowledgedStorageNodeAlerts(Subject var1);

    public PageList<Alert> findNotAcknowledgedStorageNodeAlerts(Subject var1, StorageNode var2);

    public PageList<Alert> findAllStorageNodeAlerts(Subject var1);

    public PageList<Alert> findAllStorageNodeAlerts(Subject var1, StorageNode var2);

    public StorageNode findStorageNodeByAddress(InetAddress var1);

    public Map<Integer, Integer> findResourcesWithAlertDefinitions();

    public Integer[] findResourcesWithAlertDefinitions(StorageNode var1);

    public void prepareNodeForUpgrade(Subject var1, StorageNode var2);

    public void runClusterMaintenance(Subject var1);

    public void scheduleOperationInNewTransaction(Subject var1, ResourceOperationSchedule var2);

    public Map<String, List<MeasurementDataNumericHighLowComposite>> findStorageNodeLoadDataForLast(Subject var1, StorageNode var2, long var3, long var5, int var7);

    public StorageNode createStorageNode(Resource var1, StorageClusterSettings var2);

    public void deployStorageNode(Subject var1, StorageNode var2);

    public void undeployStorageNode(Subject var1, StorageNode var2);
}

