/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.content;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.clientapi.server.content.ContentDiscoveryReport;
import org.rhq.core.clientapi.server.content.ContentServerService;
import org.rhq.core.clientapi.server.content.ContentServiceResponse;
import org.rhq.core.domain.content.PackageDetailsKey;
import org.rhq.core.domain.content.composite.PackageVersionMetadataComposite;
import org.rhq.core.domain.content.transfer.DeployPackagesResponse;
import org.rhq.core.domain.content.transfer.RemovePackagesResponse;
import org.rhq.core.domain.content.transfer.ResourcePackageDetails;
import org.rhq.core.domain.util.PageControl;
import org.rhq.core.domain.util.PageList;
import org.rhq.enterprise.server.content.ContentManagerLocal;
import org.rhq.enterprise.server.content.ContentSourceManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;

public class ContentServerServiceImpl
implements ContentServerService {
    private final Log log = LogFactory.getLog(this.getClass());

    public void mergeDiscoveredPackages(ContentDiscoveryReport report) {
        long start = System.currentTimeMillis();
        ContentManagerLocal contentManager = LookupUtil.getContentManager();
        contentManager.mergeDiscoveredPackages(report);
        long elapsed = System.currentTimeMillis() - start;
        if (elapsed > 30000L) {
            this.log.info((Object)("Performance: merged package report [" + report + "] in (" + elapsed + ")ms"));
        } else if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Performance: merged package report [" + report + "] in (" + elapsed + ")ms"));
        }
    }

    public void completeDeployPackageRequest(DeployPackagesResponse response) {
        ContentManagerLocal contentManager = LookupUtil.getContentManager();
        contentManager.completeDeployPackageRequest(response);
    }

    public void completeDeletePackageRequest(RemovePackagesResponse response) {
        ContentManagerLocal contentManager = LookupUtil.getContentManager();
        contentManager.completeDeletePackageRequest(response);
    }

    public void completeRetrievePackageBitsRequest(ContentServiceResponse response, InputStream contentStream) {
        ContentManagerLocal contentManager = LookupUtil.getContentManager();
        contentManager.completeRetrievePackageBitsRequest(response, contentStream);
    }

    public Set<ResourcePackageDetails> loadDependencies(int requestId, Set<PackageDetailsKey> dependencyPackages) {
        ContentManagerLocal contentManager = LookupUtil.getContentManager();
        Set<ResourcePackageDetails> packageDetails = contentManager.loadDependencies(requestId, dependencyPackages);
        return packageDetails;
    }

    public long downloadPackageBitsGivenResource(int resourceId, PackageDetailsKey packageDetailsKey, OutputStream outputStream) {
        ContentSourceManagerLocal manager = LookupUtil.getContentSourceManager();
        return manager.outputPackageVersionBitsGivenResource(resourceId, packageDetailsKey, outputStream);
    }

    public long downloadPackageBitsForChildResource(int parentResourceId, String resourceTypeName, PackageDetailsKey packageDetailsKey, OutputStream outputStream) {
        ContentSourceManagerLocal manager = LookupUtil.getContentSourceManager();
        return manager.outputPackageBitsForChildResource(parentResourceId, resourceTypeName, packageDetailsKey, outputStream);
    }

    public long downloadPackageBitsRangeGivenResource(int resourceId, PackageDetailsKey packageDetailsKey, OutputStream outputStream, long startByte, long endByte) {
        ContentSourceManagerLocal manager = LookupUtil.getContentSourceManager();
        return manager.outputPackageVersionBitsRangeGivenResource(resourceId, packageDetailsKey, outputStream, startByte, endByte);
    }

    public PageList<PackageVersionMetadataComposite> getPackageVersionMetadata(int resourceId, PageControl pc) {
        ContentSourceManagerLocal manager = LookupUtil.getContentSourceManager();
        long start = System.currentTimeMillis();
        PageList<PackageVersionMetadataComposite> metadataMap = manager.getPackageVersionMetadata(resourceId, pc);
        long elapsed = System.currentTimeMillis() - start;
        if (elapsed > 30000L) {
            this.log.info((Object)("Performance: metadata for resource [" + resourceId + "] has [" + metadataMap.size() + "] packages in (" + elapsed + ")ms"));
        } else if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Performance: metadata for resource [" + resourceId + "] has [" + metadataMap.size() + "] packages in (" + elapsed + ")ms"));
        }
        return metadataMap;
    }

    public String getResourceSubscriptionMD5(int resourceId) {
        ContentSourceManagerLocal manager = LookupUtil.getContentSourceManager();
        long start = System.currentTimeMillis();
        String metadataMD5 = manager.getResourceSubscriptionMD5(resourceId);
        long elapsed = System.currentTimeMillis() - start;
        if (elapsed > 5000L) {
            this.log.info((Object)("Performance: metadata for resource [" + resourceId + "] has MD5 [" + metadataMD5 + "] in (" + elapsed + ")ms"));
        } else if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Performance: metadata for resource [" + resourceId + "] has MD5 [" + metadataMD5 + "] in (" + elapsed + ")ms"));
        }
        return metadataMD5;
    }

    public long getPackageBitsLength(int resourceId, PackageDetailsKey packageDetailsKey) {
        ContentSourceManagerLocal manager = LookupUtil.getContentSourceManager();
        long size = manager.getPackageBitsLength(resourceId, packageDetailsKey);
        return size;
    }

    public boolean preLoadRemoteContent(int resourceId, PackageDetailsKey packageDetailsKey) {
        ContentSourceManagerLocal manager = LookupUtil.getContentSourceManager();
        return manager.downloadPackageBits(resourceId, packageDetailsKey);
    }
}

