/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.scheduler;

import java.io.Closeable;
import java.io.InputStream;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.ejb.ConcurrencyManagement;
import javax.ejb.ConcurrencyManagementType;
import javax.ejb.LocalBean;
import javax.ejb.Singleton;
import javax.ejb.Startup;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.util.StringPropertyReplacer;
import org.quartz.Calendar;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobListener;
import org.quartz.Scheduler;
import org.quartz.SchedulerContext;
import org.quartz.SchedulerException;
import org.quartz.SchedulerListener;
import org.quartz.SchedulerMetaData;
import org.quartz.Trigger;
import org.quartz.TriggerListener;
import org.quartz.UnableToInterruptJobException;
import org.quartz.impl.StdSchedulerFactory;
import org.quartz.spi.JobFactory;
import org.rhq.core.util.stream.StreamUtil;
import org.rhq.enterprise.server.scheduler.SchedulerServiceMBean;
import org.rhq.enterprise.server.util.JMXUtil;

@Singleton
@Startup
@LocalBean
@ConcurrencyManagement(value=ConcurrencyManagementType.BEAN)
@TransactionAttribute(value=TransactionAttributeType.SUPPORTS)
public class SchedulerService
implements SchedulerServiceMBean {
    private static final Log LOG = LogFactory.getLog(SchedulerService.class);
    private static final String TIMEOUT_PROPERTY_NAME = "rhq.server.operation-timeout";
    private Properties quartzProperties;
    private StdSchedulerFactory schedulerFactory = new StdSchedulerFactory();
    private Scheduler scheduler;

    public Properties getQuartzProperties() {
        return this.quartzProperties;
    }

    public void setQuartzProperties(Properties quartzProps) throws SchedulerException {
        if (quartzProps != null) {
            Properties overrides = new Properties();
            for (Map.Entry<Object, Object> entry : quartzProps.entrySet()) {
                String key = entry.getKey().toString();
                String value = entry.getValue().toString();
                value = StringPropertyReplacer.replaceProperties((String)value);
                overrides.put(key, value);
            }
            quartzProps = overrides;
        }
        this.quartzProperties = quartzProps;
        this.schedulerFactory.initialize(quartzProps);
        LOG.info((Object)("Scheduler has a default operation timeout of [" + this.getDefaultOperationTimeout() + "] seconds."));
    }

    public Integer getDefaultOperationTimeout() {
        Integer timeout = null;
        if (this.quartzProperties != null) {
            String timeoutStr = this.quartzProperties.getProperty(TIMEOUT_PROPERTY_NAME);
            try {
                timeout = Integer.valueOf(timeoutStr);
            }
            catch (Exception e) {
                LOG.warn((Object)("Invalid operation timeout value specified in the quartz properties: rhq.server.operation-timeout=" + timeoutStr));
            }
        }
        return timeout;
    }

    public void initQuartzScheduler() throws SchedulerException {
        if (this.scheduler == null) {
            LOG.debug((Object)"Scheduler service will initialize Quartz scheduler now.");
            this.scheduler = this.schedulerFactory.getScheduler();
        } else {
            LOG.debug((Object)"Quartz scheduler is initialized and can be started");
        }
    }

    public void startQuartzScheduler() throws SchedulerException {
        this.initQuartzScheduler();
        LOG.info((Object)"Scheduler service will start Quartz scheduler now - jobs will begin executing.");
        this.scheduler.start();
    }

    public synchronized void stop() throws SchedulerException {
        if (this.scheduler != null && !this.scheduler.isShutdown()) {
            LOG.info((Object)("Stopping " + this.scheduler));
            this.shutdown();
            this.scheduler = null;
        }
    }

    public String getSchedulerName() throws SchedulerException {
        return this.scheduler.getSchedulerName();
    }

    public String getSchedulerInstanceId() throws SchedulerException {
        return this.scheduler.getSchedulerInstanceId();
    }

    public SchedulerContext getContext() throws SchedulerException {
        return this.scheduler.getContext();
    }

    public SchedulerMetaData getMetaData() throws SchedulerException {
        return this.scheduler.getMetaData();
    }

    public void start() {
        LOG.debug((Object)"Scheduler Service has started - however, Quartz is not going to be starting yet");
    }

    @Deprecated
    public void pause() throws SchedulerException {
        this.scheduler.pause();
    }

    @Deprecated
    public boolean isPaused() throws SchedulerException {
        return this.scheduler.isPaused();
    }

    public void shutdown() throws SchedulerException {
        this.scheduler.shutdown();
    }

    public void shutdown(boolean waitForJobsToComplete) throws SchedulerException {
        this.scheduler.shutdown(waitForJobsToComplete);
    }

    public boolean isShutdown() throws SchedulerException {
        return this.scheduler.isShutdown();
    }

    public List getCurrentlyExecutingJobs() throws SchedulerException {
        return this.scheduler.getCurrentlyExecutingJobs();
    }

    public Date scheduleJob(JobDetail jobDetail, Trigger trigger) throws SchedulerException {
        return this.scheduler.scheduleJob(jobDetail, trigger);
    }

    public Date scheduleJob(Trigger trigger) throws SchedulerException {
        return this.scheduler.scheduleJob(trigger);
    }

    public void addJob(JobDetail jobDetail, boolean replace) throws SchedulerException {
        this.scheduler.addJob(jobDetail, replace);
    }

    public boolean deleteJob(String jobName, String groupName) throws SchedulerException {
        return this.scheduler.deleteJob(jobName, groupName);
    }

    public boolean unscheduleJob(String triggerName, String groupName) throws SchedulerException {
        return this.scheduler.unscheduleJob(triggerName, groupName);
    }

    public void triggerJob(String jobName, String groupName) throws SchedulerException {
        this.scheduler.triggerJob(jobName, groupName);
    }

    public void triggerJobWithVolatileTrigger(String jobName, String groupName) throws SchedulerException {
        this.scheduler.triggerJobWithVolatileTrigger(jobName, groupName);
    }

    public void pauseTrigger(String triggerName, String groupName) throws SchedulerException {
        this.scheduler.pauseTrigger(triggerName, groupName);
    }

    public void pauseTriggerGroup(String groupName) throws SchedulerException {
        this.scheduler.pauseTriggerGroup(groupName);
    }

    public void pauseJob(String jobName, String groupName) throws SchedulerException {
        this.scheduler.pauseJob(jobName, groupName);
    }

    public void pauseJobGroup(String groupName) throws SchedulerException {
        this.scheduler.pauseJobGroup(groupName);
    }

    public void resumeTrigger(String triggerName, String groupName) throws SchedulerException {
        this.scheduler.resumeTrigger(triggerName, groupName);
    }

    public void resumeTriggerGroup(String groupName) throws SchedulerException {
        this.scheduler.resumeTriggerGroup(groupName);
    }

    public void resumeJob(String jobName, String groupName) throws SchedulerException {
        this.scheduler.resumeJob(jobName, groupName);
    }

    public void resumeJobGroup(String groupName) throws SchedulerException {
        this.scheduler.resumeJobGroup(groupName);
    }

    public String[] getJobGroupNames() throws SchedulerException {
        return this.scheduler.getJobGroupNames();
    }

    public String[] getJobNames(String groupName) throws SchedulerException {
        return this.scheduler.getJobNames(groupName);
    }

    public Trigger[] getTriggersOfJob(String jobName, String groupName) throws SchedulerException {
        return this.scheduler.getTriggersOfJob(jobName, groupName);
    }

    public String[] getTriggerGroupNames() throws SchedulerException {
        return this.scheduler.getTriggerGroupNames();
    }

    public String[] getTriggerNames(String groupName) throws SchedulerException {
        return this.scheduler.getTriggerNames(groupName);
    }

    public JobDetail getJobDetail(String jobName, String jobGroup) throws SchedulerException {
        return this.scheduler.getJobDetail(jobName, jobGroup);
    }

    public Trigger getTrigger(String triggerName, String triggerGroup) throws SchedulerException {
        return this.scheduler.getTrigger(triggerName, triggerGroup);
    }

    public boolean deleteCalendar(String calName) throws SchedulerException {
        return this.scheduler.deleteCalendar(calName);
    }

    public Calendar getCalendar(String calName) throws SchedulerException {
        return this.scheduler.getCalendar(calName);
    }

    public String[] getCalendarNames() throws SchedulerException {
        return this.scheduler.getCalendarNames();
    }

    public void addGlobalJobListener(JobListener jobListener) throws SchedulerException {
        this.scheduler.addGlobalJobListener(jobListener);
    }

    public void addJobListener(JobListener jobListener) throws SchedulerException {
        this.scheduler.addJobListener(jobListener);
    }

    public boolean removeGlobalJobListener(JobListener jobListener) throws SchedulerException {
        return this.scheduler.removeGlobalJobListener(jobListener);
    }

    public boolean removeJobListener(String name) throws SchedulerException {
        return this.scheduler.removeJobListener(name);
    }

    public List getGlobalJobListeners() throws SchedulerException {
        return this.scheduler.getGlobalJobListeners();
    }

    public Set getJobListenerNames() throws SchedulerException {
        return this.scheduler.getJobListenerNames();
    }

    public JobListener getJobListener(String name) throws SchedulerException {
        return this.scheduler.getJobListener(name);
    }

    public void addGlobalTriggerListener(TriggerListener triggerListener) throws SchedulerException {
        this.scheduler.addGlobalTriggerListener(triggerListener);
    }

    public void addTriggerListener(TriggerListener triggerListener) throws SchedulerException {
        this.scheduler.addTriggerListener(triggerListener);
    }

    public boolean removeGlobalTriggerListener(TriggerListener triggerListener) throws SchedulerException {
        return this.scheduler.removeGlobalTriggerListener(triggerListener);
    }

    public boolean removeTriggerListener(String name) throws SchedulerException {
        return this.scheduler.removeTriggerListener(name);
    }

    public List getGlobalTriggerListeners() throws SchedulerException {
        return this.scheduler.getGlobalTriggerListeners();
    }

    public Set getTriggerListenerNames() throws SchedulerException {
        return this.scheduler.getTriggerListenerNames();
    }

    public TriggerListener getTriggerListener(String name) throws SchedulerException {
        return this.scheduler.getTriggerListener(name);
    }

    public void addSchedulerListener(SchedulerListener schedulerListener) throws SchedulerException {
        this.scheduler.addSchedulerListener(schedulerListener);
    }

    public boolean removeSchedulerListener(SchedulerListener schedulerListener) throws SchedulerException {
        return this.scheduler.removeSchedulerListener(schedulerListener);
    }

    public List getSchedulerListeners() throws SchedulerException {
        return this.scheduler.getSchedulerListeners();
    }

    @PostConstruct
    private void init() {
        Properties properties = new Properties();
        InputStream propertiesStream = this.getClass().getClassLoader().getResourceAsStream("quartz.properties");
        try {
            properties.load(propertiesStream);
            this.setQuartzProperties(properties);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            StreamUtil.safeClose((Closeable)propertiesStream);
        }
        JMXUtil.registerMBean(this, SCHEDULER_MBEAN_NAME);
    }

    @PreDestroy
    private void destroy() {
        try {
            this.stop();
        }
        catch (SchedulerException schedulerException) {
            // empty catch block
        }
        JMXUtil.unregisterMBeanQuietly(SCHEDULER_MBEAN_NAME);
    }

    public void addCalendar(String calName, Calendar calendar, boolean replace, boolean updateTriggers) throws SchedulerException {
        this.scheduler.addCalendar(calName, calendar, replace, updateTriggers);
    }

    public Set getPausedTriggerGroups() throws SchedulerException {
        return this.scheduler.getPausedTriggerGroups();
    }

    public int getTriggerState(String triggerName, String triggerGroup) throws SchedulerException {
        return this.scheduler.getTriggerState(triggerName, triggerGroup);
    }

    public boolean interrupt(String jobName, String groupName) throws UnableToInterruptJobException {
        return this.scheduler.interrupt(jobName, groupName);
    }

    public boolean isInStandbyMode() throws SchedulerException {
        return this.scheduler.isInStandbyMode();
    }

    public void pauseAll() throws SchedulerException {
        this.scheduler.pauseAll();
    }

    public Date rescheduleJob(String triggerName, String groupName, Trigger newTrigger) throws SchedulerException {
        return this.scheduler.rescheduleJob(triggerName, groupName, newTrigger);
    }

    public void resumeAll() throws SchedulerException {
        this.scheduler.resumeAll();
    }

    public void setJobFactory(JobFactory factory) throws SchedulerException {
        this.scheduler.setJobFactory(factory);
    }

    public void standby() throws SchedulerException {
        this.scheduler.standby();
    }

    public void triggerJob(String jobName, String groupName, JobDataMap data) throws SchedulerException {
        this.scheduler.triggerJob(jobName, groupName, data);
    }

    public void triggerJobWithVolatileTrigger(String jobName, String groupName, JobDataMap data) throws SchedulerException {
        this.scheduler.triggerJob(jobName, groupName, data);
    }

    public JobListener getGlobalJobListener(String jobName) throws SchedulerException {
        return this.scheduler.getGlobalJobListener(jobName);
    }

    public TriggerListener getGlobalTriggerListener(String triggerName) throws SchedulerException {
        return this.scheduler.getGlobalTriggerListener(triggerName);
    }

    public boolean isStarted() throws SchedulerException {
        return this.scheduler.isStarted();
    }

    public boolean removeGlobalJobListener(String jobName) throws SchedulerException {
        return this.scheduler.removeGlobalJobListener(jobName);
    }

    public boolean removeGlobalTriggerListener(String triggerName) throws SchedulerException {
        return this.scheduler.removeGlobalTriggerListener(triggerName);
    }

    public void startDelayed(int delay) throws SchedulerException {
        this.scheduler.startDelayed(delay);
    }
}

