/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.search.translation;

import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.resource.ResourceCategory;
import org.rhq.core.domain.resource.group.GroupCategory;
import org.rhq.enterprise.server.search.SearchExpressionException;
import org.rhq.enterprise.server.search.common.SearchQueryGenerationUtility;
import org.rhq.enterprise.server.search.translation.AbstractSearchTranslator;
import org.rhq.enterprise.server.search.translation.antlr.RHQLAdvancedTerm;
import org.rhq.enterprise.server.search.translation.antlr.RHQLComparisonOperator;
import org.rhq.enterprise.server.search.translation.jpql.SearchFragment;

public class GroupSearchTranslator
extends AbstractSearchTranslator {
    public GroupSearchTranslator(Subject subject) {
        super(subject);
    }

    @Override
    public SearchFragment getSearchFragment(String alias, RHQLAdvancedTerm term) {
        String path = term.getPath();
        RHQLComparisonOperator op = term.getOperator();
        String param = term.getParam();
        String filter = term.getValue();
        if (path.equals("availability")) {
            if (op == RHQLComparisonOperator.NOT_NULL || op == RHQLComparisonOperator.NULL) {
                return new SearchFragment(SearchFragment.Type.WHERE_CLAUSE, "true");
            }
            String comparator = null;
            comparator = op == RHQLComparisonOperator.EQUALS || op == RHQLComparisonOperator.EQUALS_STRICT ? " = " : " != ";
            String numericAvailType = null;
            numericAvailType = filter.equalsIgnoreCase("up") ? String.valueOf(AvailabilityType.UP.ordinal()) : (filter.equalsIgnoreCase("down") ? String.valueOf(AvailabilityType.DOWN.ordinal()) : (filter.equalsIgnoreCase("disabled") ? String.valueOf(AvailabilityType.DISABLED.ordinal()) : String.valueOf(AvailabilityType.UNKNOWN.ordinal())));
            return new SearchFragment(SearchFragment.Type.PRIMARY_KEY_SUBQUERY, "SELECT rg.id  FROM ResourceGroup rg  WHERE        ( SELECT COUNT(eavail.availabilityType)            FROM rg.explicitResources eres            JOIN eres.currentAvailability eavail           WHERE eavail.availabilityType = '" + numericAvailType + "' ) " + comparator + "       ( SELECT COUNT(eres) FROM rg.explicitResources eres ) ");
        }
        if (path.equals("category")) {
            return new SearchFragment(SearchFragment.Type.WHERE_CLAUSE, this.getJPQLForEnum(alias + ".resourceType.category", op, filter, ResourceCategory.class, false));
        }
        if (path.equals("groupCategory")) {
            return new SearchFragment(SearchFragment.Type.WHERE_CLAUSE, this.getJPQLForEnum(alias + ".groupCategory", op, filter, GroupCategory.class, false));
        }
        if (path.equals("type")) {
            return new SearchFragment(SearchFragment.Type.WHERE_CLAUSE, SearchQueryGenerationUtility.getJPQLForString(alias + ".resourceType.name", op, filter));
        }
        if (path.equals("plugin")) {
            return new SearchFragment(SearchFragment.Type.WHERE_CLAUSE, SearchQueryGenerationUtility.getJPQLForString(alias + ".resourceType.plugin", op, filter));
        }
        if (path.equals("name")) {
            return new SearchFragment(SearchFragment.Type.WHERE_CLAUSE, SearchQueryGenerationUtility.getJPQLForString(alias + ".name", op, filter));
        }
        if (param == null) {
            throw new SearchExpressionException("No search fragment available for " + path);
        }
        throw new SearchExpressionException("No search fragment available for " + path + "[" + param + "]");
    }
}

