/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.sync.exporters;

import java.util.Iterator;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.criteria.MeasurementDefinitionCriteria;
import org.rhq.core.domain.measurement.MeasurementDefinition;
import org.rhq.core.domain.sync.entity.MetricTemplate;
import org.rhq.core.domain.util.PageControl;
import org.rhq.core.domain.util.PageList;
import org.rhq.enterprise.server.measurement.MeasurementDefinitionManagerLocal;
import org.rhq.enterprise.server.sync.exporters.Exporter;
import org.rhq.enterprise.server.sync.exporters.ExportingIterator;
import org.rhq.enterprise.server.sync.exporters.JAXBExportingIterator;

public class MetricTemplateExporter
implements Exporter<MeasurementDefinition, MetricTemplate> {
    private MeasurementDefinitionManagerLocal measurementDefinitionManager;
    private Subject subject;

    public MetricTemplateExporter(Subject subject, MeasurementDefinitionManagerLocal measurementDefinitionManager) {
        this.subject = subject;
        this.measurementDefinitionManager = measurementDefinitionManager;
    }

    @Override
    public ExportingIterator<MetricTemplate> getExportingIterator() {
        MeasurementDefinitionCriteria criteria = new MeasurementDefinitionCriteria();
        criteria.setPageControl(PageControl.getUnlimitedInstance());
        criteria.fetchResourceType(true);
        PageList<MeasurementDefinition> defs = this.measurementDefinitionManager.findMeasurementDefinitionsByCriteria(this.subject, criteria);
        return new MetricTemplateIterator(defs.iterator());
    }

    @Override
    public String getNotes() {
        return null;
    }

    private static class MetricTemplateIterator
    extends JAXBExportingIterator<MetricTemplate, MeasurementDefinition> {
        public MetricTemplateIterator(Iterator<MeasurementDefinition> sourceIterator) {
            super(sourceIterator, MetricTemplate.class);
        }

        @Override
        public String getNotes() {
            return null;
        }

        @Override
        protected MetricTemplate convert(MeasurementDefinition object) {
            return new MetricTemplate(object);
        }
    }
}

