/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.communications.servlet;

import java.io.IOException;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.management.MBeanServer;
import javax.management.MBeanServerInvocationHandler;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jboss.logging.Logger;
import org.jboss.remoting.transport.servlet.ServletServerInvokerMBean;

public class ServerInvokerServlet
extends org.jboss.remoting.transport.servlet.web.ServerInvokerServlet {
    private static final long serialVersionUID = 1L;
    private static Logger log = Logger.getLogger(ServerInvokerServlet.class);
    private ServletConfig servletConfig;
    private AtomicInteger evilLogMessageCount = new AtomicInteger(0);
    private final AtomicBoolean alreadyInitialized = new AtomicBoolean(false);

    public void init(ServletConfig config) throws ServletException {
        super.init();
        this.servletConfig = config;
    }

    protected void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (this.initServletInvokerNow()) {
            super.processRequest(request, response);
        } else {
            response.sendError(503, "Server is not ready yet");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean initServletInvokerNow() {
        try {
            AtomicBoolean atomicBoolean = this.alreadyInitialized;
            synchronized (atomicBoolean) {
                if (!this.alreadyInitialized.get()) {
                    super.init(this.servletConfig);
                    this.alreadyInitialized.set(true);
                }
            }
            return true;
        }
        catch (Exception e) {
            int msgCount = this.evilLogMessageCount.incrementAndGet();
            if (msgCount % 10 == 0 && msgCount >= 100) {
                log.debug((Object)e);
            }
            return false;
        }
    }

    protected ServletServerInvokerMBean getInvokerFromInvokerName(ServletConfig config) throws ServletException {
        String invokerNameString = config.getInitParameter("invokerName");
        if (invokerNameString == null) {
            throw new ServletException("RHQ's use of this Servlet requires invokerName init parameter");
        }
        ObjectName invokerObjectNameQuery = null;
        try {
            invokerObjectNameQuery = new ObjectName(invokerNameString);
            this.log("invokerObjectNameQuery=" + invokerObjectNameQuery);
        }
        catch (MalformedObjectNameException e) {
            throw new ServletException("Failed to build invokerObjectNameQuery", (Throwable)e);
        }
        String mbeanServerId = config.getInitParameter("mbeanServer");
        MBeanServer mbeanServer = this.getMBeanServer(mbeanServerId);
        if (mbeanServer == null) {
            throw new ServletException("Failed to locate the MBeanServer");
        }
        Set<ObjectName> mbeans = mbeanServer.queryNames(invokerObjectNameQuery, null);
        if (mbeans.isEmpty()) {
            throw new ServletException("Could not find the remoting servlet invoker [" + invokerObjectNameQuery + "].  DURING SERVER STARTUP AND INITIALIZATION THIS IS NOT AN ERROR AND CAN BE IGNORED.  This may be a problem if occurring during normal server runtime.");
        }
        if (mbeans.size() > 1) {
            throw new ServletException("Found more than one remoting servlet invoker at [" + invokerObjectNameQuery + "]=" + mbeans);
        }
        ObjectName theInvokerObjectName = mbeans.iterator().next();
        this.log("Found RHQ remoting servlet: " + theInvokerObjectName);
        return MBeanServerInvocationHandler.newProxyInstance(mbeanServer, theInvokerObjectName, ServletServerInvokerMBean.class, false);
    }
}

