/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.communications.servlet;

import java.util.Set;
import javax.management.MBeanServer;
import javax.management.MBeanServerInvocationHandler;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import org.jboss.remoting.transport.servlet.ServletServerInvokerMBean;

public class ServerInvokerServlet
extends org.jboss.remoting.transport.servlet.web.ServerInvokerServlet {
    private static final long serialVersionUID = 1L;

    protected ServletServerInvokerMBean getInvokerFromInvokerName(ServletConfig config) throws ServletException {
        String invokerNameString = config.getInitParameter("invokerName");
        if (invokerNameString == null) {
            throw new ServletException("RHQ's use of this Servlet requires invokerName init parameter");
        }
        ObjectName invokerObjectNameQuery = null;
        try {
            invokerObjectNameQuery = new ObjectName(invokerNameString);
            this.log("invokerObjectNameQuery=" + invokerObjectNameQuery);
        }
        catch (MalformedObjectNameException e) {
            throw new ServletException("Failed to build invokerObjectNameQuery", (Throwable)e);
        }
        String mbeanServerId = config.getInitParameter("mbeanServer");
        MBeanServer mbeanServer = this.getMBeanServer(mbeanServerId);
        if (mbeanServer == null) {
            throw new ServletException("Failed to locate the MBeanServer");
        }
        Set<ObjectName> mbeans = mbeanServer.queryNames(invokerObjectNameQuery, null);
        if (mbeans.isEmpty()) {
            throw new ServletException("Could not find the remoting servlet invoker: " + invokerObjectNameQuery + " - need to wait for remoting to be initialized later");
        }
        if (mbeans.size() > 1) {
            throw new ServletException("Found more than one remoting servlet invoker at [" + invokerObjectNameQuery + "]=" + mbeans);
        }
        ObjectName theInvokerObjectName = mbeans.iterator().next();
        this.log("Found RHQ remoting servlet: " + theInvokerObjectName);
        return MBeanServerInvocationHandler.newProxyInstance(mbeanServer, theInvokerObjectName, ServletServerInvokerMBean.class, false);
    }
}

