/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.bindings.util;

import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.CtNewMethod;
import javassist.NotFoundException;
import javassist.bytecode.AttributeInfo;
import javassist.bytecode.ParameterAnnotationsAttribute;
import javassist.bytecode.annotation.Annotation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.auth.Subject;

public class InterfaceSimplifier {
    private static final Log LOG = LogFactory.getLog(InterfaceSimplifier.class);

    private InterfaceSimplifier() {
    }

    public static Class<?> simplify(Class<?> intf) {
        try {
            CtMethod[] methods;
            ClassPool cp = ClassPool.getDefault();
            String simpleName = intf.getName() + "Simple";
            try {
                CtClass cached = cp.get(simpleName);
                return Class.forName(simpleName, false, cp.getClassLoader());
            }
            catch (NotFoundException e) {
            }
            catch (ClassNotFoundException e) {
                LOG.debug((Object)("Class [" + simpleName + "] not found - cause: " + e));
            }
            CtClass cc = cp.get(intf.getName());
            CtClass cz = cp.getAndRename(intf.getName(), simpleName);
            cz.defrost();
            cz.setSuperclass(cc);
            for (CtMethod originalMethod : methods = cc.getMethods()) {
                CtClass[] params = originalMethod.getParameterTypes();
                if (params.length <= 0 || !params[0].getName().equals(Subject.class.getName())) continue;
                CtClass[] simpleParams = new CtClass[params.length - 1];
                System.arraycopy(params, 1, simpleParams, 0, params.length - 1);
                cz.defrost();
                CtMethod newMethod = CtNewMethod.abstractMethod((CtClass)originalMethod.getReturnType(), (String)originalMethod.getName(), (CtClass[])simpleParams, null, (CtClass)cz);
                ParameterAnnotationsAttribute originalAnnotationsAttribute = (ParameterAnnotationsAttribute)originalMethod.getMethodInfo().getAttribute("RuntimeVisibleParameterAnnotations");
                if (originalAnnotationsAttribute != null) {
                    Annotation[][] originalAnnotations = originalAnnotationsAttribute.getAnnotations();
                    Annotation[][] newAnnotations = new Annotation[originalAnnotations.length - 1][];
                    for (int i = 1; i < originalAnnotations.length; ++i) {
                        newAnnotations[i - 1] = new Annotation[originalAnnotations[i].length];
                        System.arraycopy(originalAnnotations[i], 0, newAnnotations[i - 1], 0, originalAnnotations[i].length);
                    }
                    ParameterAnnotationsAttribute newAnnotationsAttribute = new ParameterAnnotationsAttribute(newMethod.getMethodInfo().getConstPool(), "RuntimeVisibleParameterAnnotations");
                    newAnnotationsAttribute.setAnnotations((Annotation[][])newAnnotations);
                    newMethod.getMethodInfo().addAttribute((AttributeInfo)newAnnotationsAttribute);
                }
                cz.addMethod(newMethod);
            }
            return cz.toClass();
        }
        catch (NotFoundException e) {
            LOG.debug((Object)("Failed to simplify " + intf + " - cause: " + (Object)((Object)e)));
        }
        catch (CannotCompileException e) {
            LOG.error((Object)("Failed to simplify " + intf + "."), (Throwable)e);
        }
        return intf;
    }
}

