/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.bindings.util;

import java.util.Collection;
import java.util.Map;
import org.rhq.core.domain.configuration.definition.ConfigurationDefinition;
import org.rhq.core.domain.configuration.definition.PropertyDefinition;
import org.rhq.core.domain.configuration.definition.PropertyDefinitionList;
import org.rhq.core.domain.configuration.definition.PropertyDefinitionMap;
import org.rhq.core.domain.configuration.definition.PropertyDefinitionSimple;
import org.rhq.core.domain.content.PackageType;
import org.rhq.core.domain.measurement.MeasurementDefinition;
import org.rhq.core.domain.operation.OperationDefinition;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.util.MessageDigestGenerator;

public class ResourceTypeFingerprint {
    private String digest;

    public ResourceTypeFingerprint(ResourceType rt, Collection<MeasurementDefinition> measurements, Collection<OperationDefinition> operations, Collection<PackageType> packageTypes, ConfigurationDefinition pluginConfigurationDefinition, ConfigurationDefinition resourceConfigurationDefinition) {
        this.digest = ResourceTypeFingerprint.computeDigest(rt, measurements, operations, packageTypes, pluginConfigurationDefinition, resourceConfigurationDefinition);
    }

    public int hashCode() {
        return this.digest.hashCode();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ResourceTypeFingerprint)) {
            return false;
        }
        ResourceTypeFingerprint o = (ResourceTypeFingerprint)other;
        return this.digest.equals(o.digest);
    }

    public String toString() {
        return this.digest;
    }

    private static String computeDigest(ResourceType rt, Collection<MeasurementDefinition> measurements, Collection<OperationDefinition> operations, Collection<PackageType> packageTypes, ConfigurationDefinition pluginConfigurationDefinition, ConfigurationDefinition resourceConfigurationDefinition) {
        StringBuilder representation = new StringBuilder();
        ResourceTypeFingerprint.addResourceTypeRepresentation(rt, representation);
        ResourceTypeFingerprint.addMeasurementDefinitionsRepresentations(measurements, representation);
        ResourceTypeFingerprint.addOperationDefinitionsRepresentations(operations, representation);
        ResourceTypeFingerprint.addPackageTypesRepresentations(packageTypes, representation);
        ResourceTypeFingerprint.addRepresentation(pluginConfigurationDefinition, representation);
        ResourceTypeFingerprint.addRepresentation(resourceConfigurationDefinition, representation);
        return new MessageDigestGenerator("SHA-256").calcDigestString(representation.toString());
    }

    private static void addResourceTypeRepresentation(ResourceType rt, StringBuilder bld) {
        bld.append(rt.getName()).append(rt.getPlugin());
    }

    private static void addMeasurementDefinitionsRepresentations(Collection<MeasurementDefinition> defs, StringBuilder bld) {
        if (defs == null) {
            bld.append("null");
        } else {
            for (MeasurementDefinition d : defs) {
                ResourceTypeFingerprint.addRepresentation(d, bld);
            }
        }
    }

    private static void addOperationDefinitionsRepresentations(Collection<OperationDefinition> defs, StringBuilder bld) {
        if (defs == null) {
            bld.append("null");
        } else {
            for (OperationDefinition d : defs) {
                ResourceTypeFingerprint.addRepresentation(d, bld);
            }
        }
    }

    private static void addPackageTypesRepresentations(Collection<PackageType> defs, StringBuilder bld) {
        if (defs == null) {
            bld.append("null");
        } else {
            for (PackageType d : defs) {
                ResourceTypeFingerprint.addRepresentation(d, bld);
            }
        }
    }

    private static void addRepresentation(MeasurementDefinition md, StringBuilder bld) {
        bld.append(md.getName());
    }

    private static void addRepresentation(OperationDefinition od, StringBuilder bld) {
        bld.append(od.getName());
        ResourceTypeFingerprint.addRepresentation(od.getResultsConfigurationDefinition(), bld);
        ResourceTypeFingerprint.addRepresentation(od.getParametersConfigurationDefinition(), bld);
    }

    private static void addRepresentation(PackageType pt, StringBuilder bld) {
        bld.append(pt.getName());
    }

    private static void addRepresentation(ConfigurationDefinition cd, StringBuilder bld) {
        if (cd == null) {
            bld.append("null");
        } else {
            ResourceTypeFingerprint.addRepresentation(cd.getPropertyDefinitions(), bld);
        }
    }

    private static void addRepresentation(Map<String, PropertyDefinition> defs, StringBuilder bld) {
        for (Map.Entry<String, PropertyDefinition> entry : defs.entrySet()) {
            PropertyDefinition def = entry.getValue();
            ResourceTypeFingerprint.addRepresentation(def, bld);
        }
    }

    private static void addRepresentation(PropertyDefinition def, StringBuilder bld) {
        if (def instanceof PropertyDefinitionSimple) {
            ResourceTypeFingerprint.addRepresentation((PropertyDefinitionSimple)def, bld);
        } else if (def instanceof PropertyDefinitionMap) {
            ResourceTypeFingerprint.addRepresentation((PropertyDefinitionMap)def, bld);
        } else if (def instanceof PropertyDefinitionList) {
            ResourceTypeFingerprint.addRepresentation((PropertyDefinitionList)def, bld);
        }
    }

    private static void addRepresentation(PropertyDefinitionSimple p, StringBuilder bld) {
        bld.append(p.getName()).append(p.getType().name());
    }

    private static void addRepresentation(PropertyDefinitionMap pm, StringBuilder bld) {
        bld.append(pm.getName());
        ResourceTypeFingerprint.addRepresentation(pm.getPropertyDefinitions(), bld);
    }

    private static void addRepresentation(PropertyDefinitionList pl, StringBuilder bld) {
        bld.append(pl.getName());
        ResourceTypeFingerprint.addRepresentation(pl.getMemberDefinition(), bld);
    }
}

