/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.bindings.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import org.rhq.bindings.client.RhqFacade;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.criteria.ResourceCriteria;
import org.rhq.core.domain.criteria.ResourceOperationHistoryCriteria;
import org.rhq.core.domain.operation.OperationRequestStatus;
import org.rhq.core.domain.operation.ResourceOperationHistory;
import org.rhq.core.domain.operation.bean.ResourceOperationSchedule;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.util.PageList;
import org.rhq.core.domain.util.PageOrdering;
import org.rhq.enterprise.server.resource.ResourceManagerRemote;

public class ScriptUtil {
    private RhqFacade remoteClient;
    private ScriptEngine scriptEngine;

    public ScriptUtil(RhqFacade remoteClient) {
        this.remoteClient = remoteClient;
    }

    public void init(ScriptEngine scriptEngine) {
        this.scriptEngine = scriptEngine;
    }

    public PageList<Resource> findResources(String string) {
        ResourceManagerRemote resourceManager = this.remoteClient.getResourceManager();
        ResourceCriteria criteria = new ResourceCriteria();
        criteria.addFilterName(string);
        return resourceManager.findResourcesByCriteria(this.getSubjectFromEngine(), criteria);
    }

    public byte[] getFileBytes(String fileName) {
        byte[] bytes;
        File file = new File(fileName);
        long length = file.length();
        if (length > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Can not read file larger than 2147483647 byte: " + fileName);
        }
        InputStream is = null;
        try {
            bytes = new byte[(int)length];
            is = new FileInputStream(file);
            int offset = 0;
            int bytesRead = 0;
            bytesRead = 0;
            for (offset = 0; offset < bytes.length && bytesRead >= 0; offset += bytesRead) {
                bytesRead = is.read(bytes, offset, bytes.length - offset);
            }
            if (offset < bytes.length) {
                throw new RuntimeException("Could not read entire file " + file.getName() + ", only " + offset + " of " + bytes.length + " bytes read");
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException("Error reading file: " + ioe.getMessage());
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException ioe) {
                throw new RuntimeException("Error closing file: " + ioe.getMessage());
            }
        }
        return bytes;
    }

    public void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException ie) {
            throw new RuntimeException(ie);
        }
    }

    public ResourceOperationHistory waitForScheduledOperationToComplete(ResourceOperationSchedule schedule) throws InterruptedException {
        return this.waitForScheduledOperationToComplete(schedule, 1000L, 10);
    }

    public ResourceOperationHistory waitForScheduledOperationToComplete(ResourceOperationSchedule schedule, long intervalDuration, int maxIntervals) throws InterruptedException {
        ResourceOperationHistoryCriteria criteria = new ResourceOperationHistoryCriteria();
        criteria.addFilterJobId(schedule.getJobId());
        criteria.addFilterResourceIds(new Integer[]{schedule.getResource().getId()});
        criteria.addSortStartTime(PageOrdering.DESC);
        criteria.setPaging(0, 1);
        criteria.fetchOperationDefinition(true);
        criteria.fetchParameters(true);
        criteria.fetchResults(true);
        ResourceOperationHistory history = null;
        for (int i = 0; history == null && i < maxIntervals; ++i) {
            Thread.sleep(intervalDuration);
            PageList histories = this.remoteClient.getOperationManager().findResourceOperationHistoriesByCriteria(this.remoteClient.getSubject(), criteria);
            if (histories.size() <= 0 || ((ResourceOperationHistory)histories.get(0)).getStatus() == OperationRequestStatus.INPROGRESS) continue;
            history = (ResourceOperationHistory)histories.get(0);
        }
        return history;
    }

    public boolean isDefined(String identifier) {
        Bindings engineBindings = this.scriptEngine.getBindings(100);
        Bindings globalBindings = this.scriptEngine.getBindings(200);
        return engineBindings.containsKey(identifier) || globalBindings.containsKey(identifier);
    }

    private Subject getSubjectFromEngine() {
        return (Subject)this.findBinding("subject");
    }

    private Object findBinding(String identifier) {
        Bindings engineBindings = this.scriptEngine.getBindings(100);
        Bindings globalBindings = this.scriptEngine.getBindings(200);
        if (engineBindings.containsKey(identifier)) {
            return engineBindings.get(identifier);
        }
        return globalBindings.get(identifier);
    }
}

