/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.modules.plugins.script2;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.io.StringWriter;
import java.util.Set;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.measurement.DataType;
import org.rhq.core.domain.measurement.MeasurementDataNumeric;
import org.rhq.core.domain.measurement.MeasurementDataTrait;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ResourceComponent;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.core.pluginapi.measurement.MeasurementFacet;
import org.rhq.core.pluginapi.operation.OperationContext;
import org.rhq.core.pluginapi.operation.OperationFacet;
import org.rhq.core.pluginapi.operation.OperationResult;

public class ScriptComponent
implements ResourceComponent,
MeasurementFacet,
OperationFacet {
    private final Log log = LogFactory.getLog(this.getClass());
    ScriptEngine engine;
    private String theScript;

    public AvailabilityType getAvailability() {
        try {
            int tmp;
            this.engine.eval(this.theScript);
            Invocable inv = (Invocable)((Object)this.engine);
            Object ret = inv.invokeFunction("avail", new Object[0]);
            if (ret instanceof Number && (tmp = ((Number)ret).intValue()) > 0) {
                return AvailabilityType.UP;
            }
        }
        catch (ScriptException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        return AvailabilityType.DOWN;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(ResourceContext context) throws InvalidPluginConfigurationException, Exception {
        Configuration conf = context.getPluginConfiguration();
        String engineName = conf.getSimpleValue("language", null);
        if (engineName == null) {
            throw new InvalidPluginConfigurationException("No (valid) language given ");
        }
        ScriptEngineManager seMgr = new ScriptEngineManager();
        this.engine = seMgr.getEngineByName(engineName);
        String scriptName = conf.getSimpleValue("scriptName", null);
        if (scriptName == null) {
            throw new InvalidPluginConfigurationException("No (valid) script name given");
        }
        File dataDir = context.getDataDirectory();
        File scriptFile = new File(dataDir.getAbsolutePath() + "/" + scriptName);
        if (!scriptFile.exists()) {
            throw new InvalidPluginConfigurationException("Script does not exist at " + scriptFile.getAbsolutePath());
        }
        try {
            FileReader fr = new FileReader(scriptFile);
            try {
                BufferedReader reader = new BufferedReader(fr);
                try {
                    StringWriter writer = new StringWriter();
                    try {
                        int tmp;
                        while ((tmp = ((Reader)reader).read()) != -1) {
                            writer.write(tmp);
                        }
                        ((Reader)reader).close();
                        this.theScript = writer.toString();
                    }
                    finally {
                        writer.close();
                    }
                }
                finally {
                    ((Reader)reader).close();
                }
            }
            finally {
                fr.close();
            }
            this.engine.eval(this.theScript);
        }
        catch (ScriptException se) {
            throw new InvalidPluginConfigurationException(se.getMessage());
        }
    }

    public void stop() {
    }

    public void getValues(MeasurementReport report, Set<MeasurementScheduleRequest> metrics) throws Exception {
        try {
            this.engine.eval(this.theScript);
        }
        catch (ScriptException se) {
            this.log.debug((Object)se.getMessage());
            return;
        }
        for (MeasurementScheduleRequest req : metrics) {
            MeasurementDataNumeric res;
            Object ret;
            Invocable inv = (Invocable)((Object)this.engine);
            if (req.getDataType() == DataType.MEASUREMENT) {
                try {
                    ret = inv.invokeFunction("metric", req.getName());
                    if (ret instanceof Number) {
                        Double num = ((Number)ret).doubleValue();
                        res = new MeasurementDataNumeric(req, num);
                        report.addData(res);
                        continue;
                    }
                    this.log.debug((Object)("Returned value " + ret.toString() + " is no number for metric " + req.getName()));
                }
                catch (Exception e) {
                    this.log.debug((Object)e.getMessage());
                }
                continue;
            }
            if (req.getDataType() != DataType.TRAIT) continue;
            try {
                ret = inv.invokeFunction("trait", req.getName());
                if (ret instanceof String) {
                    String val = (String)ret;
                    res = new MeasurementDataTrait(req, val);
                    report.addData((MeasurementDataTrait)res);
                    continue;
                }
                this.log.debug((Object)("Returned value " + ret.toString() + " is no string for metric " + req.getName()));
            }
            catch (Exception e) {
                this.log.debug((Object)e.getMessage());
            }
        }
    }

    public void startOperationFacet(OperationContext context) {
    }

    public OperationResult invokeOperation(String name, Configuration params) throws Exception {
        OperationResult res = new OperationResult();
        if ("dummyOperation".equals(name)) {
            // empty if block
        }
        return res;
    }
}

