/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.scripting.util;

import java.io.Reader;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import java.util.Arrays;
import java.util.Collection;
import javax.script.Bindings;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptException;

public class SandboxedScriptEngine
implements ScriptEngine {
    private ScriptEngine engine;
    private AccessControlContext accessControlContext;

    public SandboxedScriptEngine(ScriptEngine engine) {
        this.engine = engine;
    }

    public SandboxedScriptEngine(ScriptEngine engine, PermissionCollection permissions) {
        this(engine);
        this.setPermissions(permissions);
    }

    public SandboxedScriptEngine(ScriptEngine engine, Collection<? extends Permission> permissions) {
        this(engine);
        this.setPermissions(permissions);
    }

    public void setPermissions(Permission ... permissions) {
        this.setPermissions(Arrays.asList(permissions));
    }

    public void setPermissions(Collection<? extends Permission> permissions) {
        Permissions ps = new Permissions();
        for (Permission permission : permissions) {
            ps.add(permission);
        }
        this.setPermissions(ps);
    }

    public void setPermissions(PermissionCollection permissions) {
        CodeSource cs = new CodeSource(null, (Certificate[])null);
        ProtectionDomain domain = new ProtectionDomain(cs, permissions);
        this.accessControlContext = new AccessControlContext(new ProtectionDomain[]{domain});
    }

    @Override
    public Object eval(final String script, final ScriptContext context) throws ScriptException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    return SandboxedScriptEngine.this.engine.eval(script, context);
                }
            }, this.accessControlContext);
        }
        catch (PrivilegedActionException e) {
            throw SandboxedScriptEngine.transfer(e);
        }
    }

    @Override
    public Object eval(final Reader reader, final ScriptContext context) throws ScriptException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    return SandboxedScriptEngine.this.engine.eval(reader, context);
                }
            }, this.accessControlContext);
        }
        catch (PrivilegedActionException e) {
            throw SandboxedScriptEngine.transfer(e);
        }
    }

    @Override
    public Object eval(final String script) throws ScriptException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    return SandboxedScriptEngine.this.engine.eval(script);
                }
            }, this.accessControlContext);
        }
        catch (PrivilegedActionException e) {
            throw SandboxedScriptEngine.transfer(e);
        }
    }

    @Override
    public Object eval(final Reader reader) throws ScriptException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    return SandboxedScriptEngine.this.engine.eval(reader);
                }
            }, this.accessControlContext);
        }
        catch (PrivilegedActionException e) {
            throw SandboxedScriptEngine.transfer(e);
        }
    }

    @Override
    public Object eval(final String script, final Bindings n) throws ScriptException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    return SandboxedScriptEngine.this.engine.eval(script, n);
                }
            }, this.accessControlContext);
        }
        catch (PrivilegedActionException e) {
            throw SandboxedScriptEngine.transfer(e);
        }
    }

    @Override
    public Object eval(final Reader reader, final Bindings n) throws ScriptException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    return SandboxedScriptEngine.this.engine.eval(reader, n);
                }
            }, this.accessControlContext);
        }
        catch (PrivilegedActionException e) {
            throw SandboxedScriptEngine.transfer(e);
        }
    }

    @Override
    public void put(String key, Object value) {
        this.engine.put(key, value);
    }

    @Override
    public Object get(String key) {
        return this.engine.get(key);
    }

    @Override
    public Bindings getBindings(int scope) {
        return this.engine.getBindings(scope);
    }

    @Override
    public void setBindings(Bindings bindings, int scope) {
        this.engine.setBindings(bindings, scope);
    }

    @Override
    public Bindings createBindings() {
        return this.engine.createBindings();
    }

    @Override
    public ScriptContext getContext() {
        return this.engine.getContext();
    }

    @Override
    public void setContext(ScriptContext context) {
        this.engine.setContext(context);
    }

    @Override
    public ScriptEngineFactory getFactory() {
        return this.engine.getFactory();
    }

    private static ScriptException transfer(PrivilegedActionException e) {
        if (e.getCause() instanceof ScriptException) {
            return (ScriptException)e.getCause();
        }
        return new ScriptException(e);
    }
}

