/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.client;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.bindings.client.RhqFacade;
import org.rhq.bindings.client.RhqManagers;
import org.rhq.bindings.util.InterfaceSimplifier;
import org.rhq.core.domain.auth.Subject;
import org.rhq.enterprise.client.LocalClientProxy;
import org.rhq.enterprise.server.alert.AlertDefinitionManagerRemote;
import org.rhq.enterprise.server.alert.AlertManagerRemote;
import org.rhq.enterprise.server.auth.SubjectManagerRemote;
import org.rhq.enterprise.server.authz.RoleManagerRemote;
import org.rhq.enterprise.server.bundle.BundleManagerRemote;
import org.rhq.enterprise.server.configuration.ConfigurationManagerRemote;
import org.rhq.enterprise.server.content.ContentManagerRemote;
import org.rhq.enterprise.server.content.RepoManagerRemote;
import org.rhq.enterprise.server.discovery.DiscoveryBossRemote;
import org.rhq.enterprise.server.drift.DriftManagerRemote;
import org.rhq.enterprise.server.event.EventManagerRemote;
import org.rhq.enterprise.server.install.remote.RemoteInstallManagerRemote;
import org.rhq.enterprise.server.measurement.AvailabilityManagerRemote;
import org.rhq.enterprise.server.measurement.CallTimeDataManagerRemote;
import org.rhq.enterprise.server.measurement.MeasurementBaselineManagerRemote;
import org.rhq.enterprise.server.measurement.MeasurementDataManagerRemote;
import org.rhq.enterprise.server.measurement.MeasurementDefinitionManagerRemote;
import org.rhq.enterprise.server.measurement.MeasurementScheduleManagerRemote;
import org.rhq.enterprise.server.operation.OperationManagerRemote;
import org.rhq.enterprise.server.report.DataAccessManagerRemote;
import org.rhq.enterprise.server.resource.ResourceFactoryManagerRemote;
import org.rhq.enterprise.server.resource.ResourceManagerRemote;
import org.rhq.enterprise.server.resource.ResourceTypeManagerRemote;
import org.rhq.enterprise.server.resource.group.ResourceGroupManagerRemote;
import org.rhq.enterprise.server.search.SavedSearchManagerRemote;
import org.rhq.enterprise.server.support.SupportManagerRemote;
import org.rhq.enterprise.server.sync.SynchronizationManagerRemote;
import org.rhq.enterprise.server.system.SystemManagerRemote;
import org.rhq.enterprise.server.tagging.TagManagerRemote;
import org.rhq.enterprise.server.util.LookupUtil;

public class LocalClient
implements RhqFacade {
    private static final Log LOG = LogFactory.getLog(LocalClient.class);
    private Subject subject;
    private Map<String, Object> managers;

    public LocalClient(Subject subject) {
        this.subject = subject;
    }

    public Subject getSubject() {
        return this.subject;
    }

    public Subject login(String user, String password) throws Exception {
        return this.subject;
    }

    public void logout() {
    }

    public boolean isLoggedIn() {
        return true;
    }

    public AlertManagerRemote getAlertManager() {
        return this.getProxy(LookupUtil.getAlertManager(), AlertManagerRemote.class);
    }

    public AlertDefinitionManagerRemote getAlertDefinitionManager() {
        return this.getProxy(LookupUtil.getAlertDefinitionManager(), AlertDefinitionManagerRemote.class);
    }

    public AvailabilityManagerRemote getAvailabilityManager() {
        return this.getProxy(LookupUtil.getAvailabilityManager(), AvailabilityManagerRemote.class);
    }

    public BundleManagerRemote getBundleManager() {
        return this.getProxy(LookupUtil.getBundleManager(), BundleManagerRemote.class);
    }

    public CallTimeDataManagerRemote getCallTimeDataManager() {
        return this.getProxy(LookupUtil.getCallTimeDataManager(), CallTimeDataManagerRemote.class);
    }

    public RepoManagerRemote getRepoManager() {
        return this.getProxy(LookupUtil.getRepoManagerLocal(), RepoManagerRemote.class);
    }

    public ConfigurationManagerRemote getConfigurationManager() {
        return this.getProxy(LookupUtil.getConfigurationManager(), ConfigurationManagerRemote.class);
    }

    public ContentManagerRemote getContentManager() {
        return this.getProxy(LookupUtil.getContentManager(), ContentManagerRemote.class);
    }

    public DataAccessManagerRemote getDataAccessManager() {
        return this.getProxy(LookupUtil.getDataAccessManager(), DataAccessManagerRemote.class);
    }

    public DiscoveryBossRemote getDiscoveryBoss() {
        return this.getProxy(LookupUtil.getDiscoveryBoss(), DiscoveryBossRemote.class);
    }

    public DriftManagerRemote getDriftManager() {
        return this.getProxy(LookupUtil.getDriftManager(), DriftManagerRemote.class);
    }

    public EventManagerRemote getEventManager() {
        return this.getProxy(LookupUtil.getEventManager(), EventManagerRemote.class);
    }

    public MeasurementBaselineManagerRemote getMeasurementBaselineManager() {
        return this.getProxy(LookupUtil.getMeasurementBaselineManager(), MeasurementBaselineManagerRemote.class);
    }

    public MeasurementDataManagerRemote getMeasurementDataManager() {
        return this.getProxy(LookupUtil.getMeasurementDataManager(), MeasurementDataManagerRemote.class);
    }

    public MeasurementDefinitionManagerRemote getMeasurementDefinitionManager() {
        return this.getProxy(LookupUtil.getMeasurementDefinitionManager(), MeasurementDefinitionManagerRemote.class);
    }

    public MeasurementScheduleManagerRemote getMeasurementScheduleManager() {
        return this.getProxy(LookupUtil.getMeasurementScheduleManager(), MeasurementScheduleManagerRemote.class);
    }

    public OperationManagerRemote getOperationManager() {
        return this.getProxy(LookupUtil.getOperationManager(), OperationManagerRemote.class);
    }

    public ResourceManagerRemote getResourceManager() {
        return this.getProxy(LookupUtil.getResourceManager(), ResourceManagerRemote.class);
    }

    public ResourceFactoryManagerRemote getResourceFactoryManager() {
        return this.getProxy(LookupUtil.getResourceFactoryManager(), ResourceFactoryManagerRemote.class);
    }

    public ResourceGroupManagerRemote getResourceGroupManager() {
        return this.getProxy(LookupUtil.getResourceGroupManager(), ResourceGroupManagerRemote.class);
    }

    public ResourceTypeManagerRemote getResourceTypeManager() {
        return this.getProxy(LookupUtil.getResourceTypeManager(), ResourceTypeManagerRemote.class);
    }

    public RoleManagerRemote getRoleManager() {
        return this.getProxy(LookupUtil.getRoleManager(), RoleManagerRemote.class);
    }

    public SavedSearchManagerRemote getSavedSearchManager() {
        return this.getProxy(LookupUtil.getSavedSearchManager(), SavedSearchManagerRemote.class);
    }

    public SubjectManagerRemote getSubjectManager() {
        return this.getProxy(LookupUtil.getSubjectManager(), SubjectManagerRemote.class);
    }

    public SupportManagerRemote getSupportManager() {
        return this.getProxy(LookupUtil.getSupportManager(), SupportManagerRemote.class);
    }

    public SystemManagerRemote getSystemManager() {
        return this.getProxy(LookupUtil.getSystemManager(), SystemManagerRemote.class);
    }

    public RemoteInstallManagerRemote getRemoteInstallManager() {
        return this.getProxy(LookupUtil.getRemoteInstallManager(), RemoteInstallManagerRemote.class);
    }

    public TagManagerRemote getTagManager() {
        return this.getProxy(LookupUtil.getTagManager(), TagManagerRemote.class);
    }

    public SynchronizationManagerRemote getSynchronizationManager() {
        return this.getProxy(LookupUtil.getSynchronizationManager(), SynchronizationManagerRemote.class);
    }

    public Map<String, Object> getManagers() {
        if (this.managers == null) {
            this.managers = new HashMap<String, Object>();
            for (RhqManagers manager : RhqManagers.values()) {
                try {
                    Method m = this.getClass().getMethod("get" + manager.name(), new Class[0]);
                    this.managers.put(manager.name(), m.invoke((Object)this, new Object[0]));
                }
                catch (Throwable e) {
                    LOG.error((Object)("Failed to load manager " + manager + " due to missing class."), e);
                }
            }
        }
        return this.managers;
    }

    private <T> T getProxy(Object slsb, Class<T> iface) {
        RhqManagers manager = RhqManagers.forInterface(iface);
        Class simplified = InterfaceSimplifier.simplify(iface);
        Object proxy = Proxy.newProxyInstance(iface.getClassLoader(), new Class[]{simplified}, (InvocationHandler)((Object)new LocalClientProxy(slsb, this, manager)));
        return iface.cast(proxy);
    }
}

